/*
 * Decompiled with CFR 0.152.
 */
package net.rafalohaki.veloauth.libs.ormlite.logger;

import net.rafalohaki.veloauth.libs.ormlite.logger.ConsoleLogBackend;
import net.rafalohaki.veloauth.libs.ormlite.logger.Level;
import net.rafalohaki.veloauth.libs.ormlite.logger.LocalLogBackend;
import net.rafalohaki.veloauth.libs.ormlite.logger.LogBackend;
import net.rafalohaki.veloauth.libs.ormlite.logger.LogBackendFactory;
import net.rafalohaki.veloauth.libs.ormlite.logger.NullLogBackend;

public enum LogBackendType implements LogBackendFactory
{
    SLF4J("net.rafalohaki.veloauth.libs.ormlite.logger.Slf4jLoggingLogBackend$Slf4jLoggingLogBackendFactory"),
    ANDROID("net.rafalohaki.veloauth.libs.ormlite.android.AndroidLogBackend$AndroidLogBackendFactory"),
    LOGBACK("net.rafalohaki.veloauth.libs.ormlite.logger.LogbackLogBackend$LogbackLogBackendFactory"),
    COMMONS_LOGGING("net.rafalohaki.veloauth.libs.ormlite.logger.CommonsLoggingLogBackend$CommonsLoggingLogBackendFactory"),
    LOG4J2("net.rafalohaki.veloauth.libs.ormlite.logger.Log4j2LogBackend$Log4j2LogBackendFactory"),
    LOG4J("net.rafalohaki.veloauth.libs.ormlite.logger.Log4jLogBackend$Log4jLogBackendFactory"),
    LOCAL(new LocalLogBackend.LocalLogBackendFactory()),
    CONSOLE(new ConsoleLogBackend.ConsoleLogBackendFactory()),
    JAVA_UTIL("net.rafalohaki.veloauth.libs.ormlite.logger.JavaUtilLogBackend$JavaUtilLogBackendFactory"),
    NULL(new NullLogBackend.NullLogBackendFactory());

    private final LogBackendFactory factory;

    private LogBackendType(LogBackendFactory factory) {
        this.factory = factory;
    }

    private LogBackendType(String logBackendFactoryClassName) {
        this.factory = this.detectFactory(logBackendFactoryClassName);
    }

    @Override
    public LogBackend createLogBackend(String classLabel) {
        return this.factory.createLogBackend(classLabel);
    }

    public boolean isAvailable() {
        return this == LOCAL || this != NULL && !(this.factory instanceof LocalLogBackend.LocalLogBackendFactory);
    }

    private LogBackendFactory detectFactory(String factoryClassName) {
        try {
            LogBackendFactory factory = (LogBackendFactory)Class.forName(factoryClassName).newInstance();
            factory.createLogBackend("test").isLevelEnabled(Level.INFO);
            return factory;
        }
        catch (Throwable th) {
            String queuedWarning = "Unable to create instance of class " + factoryClassName + " for log type " + this + ", using local log: " + th.getMessage();
            return new LocalLogBackend.LocalLogBackendFactory(queuedWarning);
        }
    }
}

