/*
 * Decompiled with CFR 0.152.
 */
package net.rafalohaki.veloauth.libs.ormlite.logger;

import net.rafalohaki.veloauth.libs.ormlite.logger.Level;
import net.rafalohaki.veloauth.libs.ormlite.logger.LogBackend;
import net.rafalohaki.veloauth.libs.ormlite.logger.LogBackendFactory;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Slf4jLoggingLogBackend
implements LogBackend {
    private final Logger logger;

    public Slf4jLoggingLogBackend(Logger logger) {
        this.logger = logger;
    }

    @Override
    public boolean isLevelEnabled(Level level) {
        switch (level) {
            case TRACE: {
                return this.logger.isTraceEnabled();
            }
            case DEBUG: {
                return this.logger.isDebugEnabled();
            }
            case WARNING: {
                return this.logger.isWarnEnabled();
            }
            case ERROR: {
                return this.logger.isErrorEnabled();
            }
            case FATAL: {
                return this.logger.isErrorEnabled();
            }
        }
        return this.logger.isInfoEnabled();
    }

    @Override
    public void log(Level level, String msg) {
        switch (level) {
            case TRACE: {
                this.logger.trace(msg);
                break;
            }
            case DEBUG: {
                this.logger.debug(msg);
                break;
            }
            case WARNING: {
                this.logger.warn(msg);
                break;
            }
            case ERROR: {
                this.logger.error(msg);
                break;
            }
            case FATAL: {
                this.logger.error(msg);
                break;
            }
            default: {
                this.logger.info(msg);
            }
        }
    }

    @Override
    public void log(Level level, String msg, Throwable t2) {
        switch (level) {
            case TRACE: {
                this.logger.trace(msg, t2);
                break;
            }
            case DEBUG: {
                this.logger.debug(msg, t2);
                break;
            }
            case WARNING: {
                this.logger.warn(msg, t2);
                break;
            }
            case ERROR: {
                this.logger.error(msg, t2);
                break;
            }
            case FATAL: {
                this.logger.error(msg, t2);
                break;
            }
            default: {
                this.logger.info(msg, t2);
            }
        }
    }

    public static class Slf4jLoggingLogBackendFactory
    implements LogBackendFactory {
        private final ILoggerFactory factory = LoggerFactory.getILoggerFactory();

        @Override
        public LogBackend createLogBackend(String classLabel) {
            return new Slf4jLoggingLogBackend(this.factory.getLogger(classLabel));
        }
    }
}

