/*
 * Decompiled with CFR 0.152.
 */
package net.rafalohaki.veloauth.libs.ormlite.stmt.mapped;

import java.sql.SQLException;
import net.rafalohaki.veloauth.libs.ormlite.dao.Dao;
import net.rafalohaki.veloauth.libs.ormlite.dao.ObjectCache;
import net.rafalohaki.veloauth.libs.ormlite.db.DatabaseType;
import net.rafalohaki.veloauth.libs.ormlite.field.FieldType;
import net.rafalohaki.veloauth.libs.ormlite.stmt.mapped.BaseMappedStatement;
import net.rafalohaki.veloauth.libs.ormlite.support.DatabaseConnection;
import net.rafalohaki.veloauth.libs.ormlite.table.TableInfo;

public class MappedUpdate<T, ID>
extends BaseMappedStatement<T, ID> {
    private final FieldType versionFieldType;
    private final int versionFieldTypeIndex;

    private MappedUpdate(Dao<T, ID> dao, TableInfo<T, ID> tableInfo, String statement, FieldType[] argFieldTypes, FieldType versionFieldType, int versionFieldTypeIndex) {
        super(dao, tableInfo, statement, argFieldTypes);
        this.versionFieldType = versionFieldType;
        this.versionFieldTypeIndex = versionFieldTypeIndex;
    }

    public static <T, ID> MappedUpdate<T, ID> build(Dao<T, ID> dao, TableInfo<T, ID> tableInfo) throws SQLException {
        FieldType idField = tableInfo.getIdField();
        if (idField == null) {
            throw new SQLException("Cannot update " + tableInfo.getDataClass() + " because it doesn't have an id field");
        }
        StringBuilder sb = new StringBuilder(64);
        DatabaseType databaseType = dao.getConnectionSource().getDatabaseType();
        MappedUpdate.appendTableName(databaseType, sb, "UPDATE ", tableInfo);
        boolean first = true;
        int argFieldC = 0;
        FieldType versionFieldType = null;
        int versionFieldTypeIndex = -1;
        for (FieldType fieldType : tableInfo.getFieldTypes()) {
            if (!MappedUpdate.isFieldUpdatable(fieldType, idField)) continue;
            if (fieldType.isVersion()) {
                versionFieldType = fieldType;
                versionFieldTypeIndex = argFieldC;
            }
            ++argFieldC;
        }
        ++argFieldC;
        if (versionFieldType != null) {
            ++argFieldC;
        }
        FieldType[] argFieldTypes = new FieldType[argFieldC];
        argFieldC = 0;
        for (FieldType fieldType : tableInfo.getFieldTypes()) {
            if (!MappedUpdate.isFieldUpdatable(fieldType, idField)) continue;
            if (first) {
                sb.append("SET ");
                first = false;
            } else {
                sb.append(", ");
            }
            MappedUpdate.appendFieldColumnName(databaseType, sb, fieldType, null);
            argFieldTypes[argFieldC++] = fieldType;
            sb.append("= ?");
        }
        sb.append(' ');
        MappedUpdate.appendWhereFieldEq(databaseType, idField, sb, null);
        argFieldTypes[argFieldC++] = idField;
        if (versionFieldType != null) {
            sb.append(" AND ");
            MappedUpdate.appendFieldColumnName(databaseType, sb, versionFieldType, null);
            sb.append("= ?");
            argFieldTypes[argFieldC++] = versionFieldType;
        }
        return new MappedUpdate<T, ID>(dao, tableInfo, sb.toString(), argFieldTypes, versionFieldType, versionFieldTypeIndex);
    }

    public int update(DatabaseConnection databaseConnection, T data, ObjectCache objectCache) throws SQLException {
        try {
            int rowC;
            if (this.argFieldTypes.length <= 1) {
                return 0;
            }
            Object[] args = this.getFieldObjects(data);
            Object newVersion = null;
            if (this.versionFieldType != null) {
                newVersion = this.versionFieldType.extractJavaFieldValue(data);
                newVersion = this.versionFieldType.moveToNextValue(newVersion);
                args[this.versionFieldTypeIndex] = this.versionFieldType.convertJavaFieldToSqlArgValue(newVersion);
            }
            if ((rowC = databaseConnection.update(this.statement, args, this.argFieldTypes)) > 0) {
                Object id;
                Object cachedData;
                if (newVersion != null) {
                    this.versionFieldType.assignField(this.connectionSource, data, newVersion, false, null);
                }
                if (objectCache != null && (cachedData = objectCache.get(this.clazz, id = this.idField.extractJavaFieldValue(data))) != null && cachedData != data) {
                    for (FieldType fieldType : this.tableInfo.getFieldTypes()) {
                        if (fieldType == this.idField) continue;
                        fieldType.assignField(this.connectionSource, cachedData, fieldType.extractJavaFieldValue(data), false, objectCache);
                    }
                }
            }
            logger.debug("update data with statement '{}' and {} args, changed {} rows", (Object)this.statement, (Object)args.length, (Object)rowC);
            if (args.length > 0) {
                logger.trace("update arguments: {}", (Object)args);
            }
            return rowC;
        }
        catch (SQLException e) {
            throw new SQLException("Unable to run update stmt on object " + data + ": " + this.statement, e);
        }
    }

    private static boolean isFieldUpdatable(FieldType fieldType, FieldType idField) {
        return fieldType != idField && !fieldType.isForeignCollection() && !fieldType.isReadOnly();
    }
}

