/*
 * Decompiled with CFR 0.152.
 */
package net.rafalohaki.veloauth.libs.ormlite.stmt.query;

import java.sql.SQLException;
import java.util.List;
import net.rafalohaki.veloauth.libs.ormlite.db.DatabaseType;
import net.rafalohaki.veloauth.libs.ormlite.stmt.ArgumentHolder;
import net.rafalohaki.veloauth.libs.ormlite.stmt.query.Clause;
import net.rafalohaki.veloauth.libs.ormlite.stmt.query.Comparison;
import net.rafalohaki.veloauth.libs.ormlite.stmt.query.Exists;
import net.rafalohaki.veloauth.libs.ormlite.stmt.query.NeedsFutureClause;

public class Not
implements Clause,
NeedsFutureClause {
    private Comparison comparison = null;
    private Exists exists = null;

    public Not() {
    }

    public Not(Clause clause) {
        this.setMissingClause(clause);
    }

    @Override
    public void setMissingClause(Clause clause) {
        if (this.comparison != null) {
            throw new IllegalArgumentException("NOT operation already has a comparison set");
        }
        if (clause instanceof Comparison) {
            this.comparison = (Comparison)clause;
        } else if (clause instanceof Exists) {
            this.exists = (Exists)clause;
        } else {
            throw new IllegalArgumentException("NOT operation can only work with comparison SQL clauses, not " + clause);
        }
    }

    @Override
    public void appendSql(DatabaseType databaseType, String tableName, StringBuilder sb, List<ArgumentHolder> selectArgList, Clause outer) throws SQLException {
        if (this.comparison == null && this.exists == null) {
            throw new IllegalStateException("Clause has not been set in NOT operation");
        }
        sb.append("(NOT ");
        if (this.comparison == null) {
            this.exists.appendSql(databaseType, tableName, sb, selectArgList, outer);
        } else {
            if (tableName != null) {
                databaseType.appendEscapedEntityName(sb, tableName);
                sb.append('.');
            }
            databaseType.appendEscapedEntityName(sb, this.comparison.getColumnName());
            sb.append(' ');
            this.comparison.appendOperation(sb);
            this.comparison.appendValue(databaseType, sb, selectArgList);
        }
        int len = sb.length();
        if (len > 0 && sb.charAt(len - 1) == ' ') {
            sb.setLength(len - 1);
        }
        sb.append(") ");
    }

    public String toString() {
        if (this.comparison == null) {
            return "NOT without comparison";
        }
        return "NOT comparison " + this.comparison;
    }
}

