/*
 * Decompiled with CFR 0.152.
 */
package net.rafalohaki.veloauth.listener;

import com.velocitypowered.api.event.ResultedEvent;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.connection.DisconnectEvent;
import com.velocitypowered.api.event.connection.LoginEvent;
import com.velocitypowered.api.event.connection.PostLoginEvent;
import com.velocitypowered.api.event.connection.PreLoginEvent;
import com.velocitypowered.api.event.player.ServerConnectedEvent;
import com.velocitypowered.api.event.player.ServerPreConnectEvent;
import com.velocitypowered.api.proxy.Player;
import java.net.InetAddress;
import java.time.Instant;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import javax.inject.Inject;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.rafalohaki.veloauth.VeloAuth;
import net.rafalohaki.veloauth.cache.AuthCache;
import net.rafalohaki.veloauth.config.Settings;
import net.rafalohaki.veloauth.database.DatabaseManager;
import net.rafalohaki.veloauth.i18n.Messages;
import net.rafalohaki.veloauth.listener.PostLoginHandler;
import net.rafalohaki.veloauth.listener.PreLoginHandler;
import net.rafalohaki.veloauth.model.RegisteredPlayer;
import net.rafalohaki.veloauth.util.AuthenticationErrorHandler;
import net.rafalohaki.veloauth.util.PlayerAddressUtils;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class AuthListener {
    private static final Marker AUTH_MARKER = MarkerFactory.getMarker("AUTH");
    private static final Marker SECURITY_MARKER = MarkerFactory.getMarker("SECURITY");
    private final VeloAuth plugin;
    private final AuthCache authCache;
    private final Settings settings;
    private final Logger logger;
    private final Messages messages;
    private final DatabaseManager databaseManager;
    private final PreLoginHandler preLoginHandler;
    private final PostLoginHandler postLoginHandler;

    @Inject
    public AuthListener(VeloAuth plugin, AuthCache authCache, Settings settings, PreLoginHandler preLoginHandler, PostLoginHandler postLoginHandler, DatabaseManager databaseManager, Messages messages) {
        this.plugin = plugin;
        this.authCache = authCache;
        this.settings = settings;
        this.logger = plugin.getLogger();
        this.databaseManager = databaseManager;
        this.messages = messages;
        this.preLoginHandler = Objects.requireNonNull(preLoginHandler, "PreLoginHandler cannot be null - initialization failed");
        this.postLoginHandler = Objects.requireNonNull(postLoginHandler, "PostLoginHandler cannot be null - initialization failed");
        if (this.logger.isInfoEnabled()) {
            this.logger.info(messages.get("connection.listener.registered", new Object[0]));
        }
    }

    private static String resolveBlockReason(boolean isAuthorized, boolean hasActiveSession) {
        if (!isAuthorized) {
            return "nieautoryzowany";
        }
        if (!hasActiveSession) {
            return "brak aktywnej sesji";
        }
        return "UUID mismatch";
    }

    @Subscribe(priority=32767)
    public void onPreLogin(PreLoginEvent event) {
        boolean existingIsPremium;
        String username = event.getUsername();
        this.logger.info("\ud83d\udd0d PreLogin: {}", (Object)username);
        if (!this.plugin.isInitialized()) {
            this.logger.warn("\ud83d\udd12 BLOKADA STARTU: Gracz {} pr\u00f3bowa\u0142 po\u0142\u0105czy\u0107 si\u0119 przed pe\u0142n\u0105 inicjalizacj\u0105 VeloAuth - blokada PreLogin", (Object)username);
            event.setResult(PreLoginEvent.PreLoginComponentResult.denied((Component)Component.text((String)"VeloAuth si\u0119 uruchamia. Spr\u00f3buj po\u0142\u0105czy\u0107 si\u0119 ponownie za chwil\u0119.", (TextColor)NamedTextColor.RED)));
            return;
        }
        if (this.preLoginHandler == null) {
            this.logger.error("CRITICAL: PreLoginHandler is null during event processing for player {}", (Object)username);
            event.setResult(PreLoginEvent.PreLoginComponentResult.denied((Component)Component.text((String)"B\u0142\u0105d inicjalizacji pluginu. Skontaktuj si\u0119 z administratorem.", (TextColor)NamedTextColor.RED)));
            return;
        }
        if (!this.preLoginHandler.isValidUsername(username)) {
            String message = "Nieprawid\u0142owy format nazwy u\u017cytkownika! U\u017cyj tylko liter, cyfr i podkre\u015blenia (max 16 znak\u00f3w).";
            this.logger.warn(SECURITY_MARKER, "[USERNAME VALIDATION FAILED] {} - invalid format", (Object)username);
            event.setResult(PreLoginEvent.PreLoginComponentResult.denied((Component)Component.text((String)message, (TextColor)NamedTextColor.RED)));
            return;
        }
        InetAddress playerAddress = PlayerAddressUtils.getAddressFromPreLogin(event);
        if (playerAddress != null && this.preLoginHandler.isBruteForceBlocked(playerAddress)) {
            String message = "Zbyt wiele nieudanych pr\u00f3b logowania. Spr\u00f3buj ponownie p\u00f3\u017aniej.";
            if (this.logger.isWarnEnabled()) {
                this.logger.warn(SECURITY_MARKER, "[BRUTE FORCE BLOCK] IP {} zablokowany", (Object)playerAddress.getHostAddress());
            }
            event.setResult(PreLoginEvent.PreLoginComponentResult.denied((Component)Component.text((String)message, (TextColor)NamedTextColor.RED)));
            return;
        }
        if (!this.settings.isPremiumCheckEnabled()) {
            this.logger.debug("Premium check wy\u0142\u0105czony w konfiguracji - wymuszam offline mode dla {}", (Object)username);
            event.setResult(PreLoginEvent.PreLoginComponentResult.forceOfflineMode());
            return;
        }
        PreLoginHandler.PremiumResolutionResult result = this.preLoginHandler.resolvePremiumStatus(username);
        boolean premium = result.premium();
        RegisteredPlayer existingPlayer = this.databaseManager.findPlayerWithRuntimeDetection(username).join().getValue();
        if (existingPlayer != null && this.preLoginHandler.isNicknameConflict(existingPlayer, premium, existingIsPremium = this.databaseManager.isPlayerPremiumRuntime(existingPlayer))) {
            this.preLoginHandler.handleNicknameConflict(event, existingPlayer, premium);
            return;
        }
        if (premium) {
            event.setResult(PreLoginEvent.PreLoginComponentResult.forceOnlineMode());
        } else {
            event.setResult(PreLoginEvent.PreLoginComponentResult.forceOfflineMode());
        }
    }

    @Subscribe(priority=32767)
    public void onLogin(LoginEvent event) {
        Player player = event.getPlayer();
        String playerName = player.getUsername();
        UUID playerUuid = player.getUniqueId();
        String playerIp = PlayerAddressUtils.getPlayerIp(player);
        boolean allowed = true;
        try {
            if (!this.plugin.isInitialized()) {
                this.logger.warn("\ud83d\udd12 BLOKADA STARTU: Gracz {} pr\u00f3bowa\u0142 zalogowa\u0107 si\u0119 przed pe\u0142n\u0105 inicjalizacj\u0105 VeloAuth - blokada logowania", (Object)playerName);
                event.setResult(ResultedEvent.ComponentResult.denied((Component)Component.text((String)"VeloAuth si\u0119 uruchamia. Spr\u00f3buj zalogowa\u0107 si\u0119 ponownie za chwil\u0119.", (TextColor)NamedTextColor.RED)));
                return;
            }
            this.logger.debug("LoginEvent dla gracza {} (UUID: {}) z IP {}", playerName, playerUuid, playerIp);
            InetAddress playerAddress = PlayerAddressUtils.getPlayerAddress(player);
            if (playerAddress != null && this.authCache.isBlocked(playerAddress)) {
                String message = String.format("Zablokowano po\u0142\u0105czenie gracza %s za zbyt wiele nieudanych pr\u00f3b logowania", playerName);
                this.logger.warn(SECURITY_MARKER, message);
                event.setResult(ResultedEvent.ComponentResult.denied((Component)Component.text((String)"Zbyt wiele nieudanych pr\u00f3b logowania. Spr\u00f3buj ponownie p\u00f3\u017aniej.", (TextColor)NamedTextColor.RED)));
                return;
            }
        }
        catch (Exception e) {
            this.logger.error("B\u0142\u0105d podczas obs\u0142ugi LoginEvent dla gracza: {}", (Object)event.getPlayer().getUsername(), (Object)e);
            event.setResult(ResultedEvent.ComponentResult.denied((Component)Component.text((String)"Wyst\u0105pi\u0142 b\u0142\u0105d podczas \u0142\u0105czenia. Spr\u00f3buj ponownie.", (TextColor)NamedTextColor.RED)));
            allowed = false;
        }
        if (allowed) {
            event.setResult(ResultedEvent.ComponentResult.allowed());
        }
    }

    @Subscribe(priority=0)
    public void onDisconnect(DisconnectEvent event) {
        try {
            Player player = event.getPlayer();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Gracz {} roz\u0142\u0105czy\u0142 si\u0119 - sesja pozostaje aktywna", (Object)player.getUsername());
            }
        }
        catch (Exception e) {
            this.logger.error("B\u0142\u0105d podczas obs\u0142ugi DisconnectEvent dla gracza: {}", (Object)event.getPlayer().getUsername(), (Object)e);
        }
    }

    @Subscribe(priority=0)
    public void onPostLogin(PostLoginEvent event) {
        Player player = event.getPlayer();
        String playerIp = PlayerAddressUtils.getPlayerIp(player);
        this.logger.debug("PostLoginEvent dla gracza {} z IP {}", (Object)player.getUsername(), (Object)playerIp);
        if (this.postLoginHandler == null) {
            this.logger.error("CRITICAL: PostLoginHandler is null during event processing for player {}", (Object)player.getUsername());
            player.disconnect((Component)Component.text((String)"B\u0142\u0105d inicjalizacji pluginu. Skontaktuj si\u0119 z administratorem.", (TextColor)NamedTextColor.RED));
            return;
        }
        try {
            if (this.postLoginHandler.shouldShowConflictMessage(player)) {
                this.postLoginHandler.showConflictResolutionMessage(player);
            }
            if (player.isOnlineMode()) {
                this.postLoginHandler.handlePremiumPlayer(player, playerIp);
                return;
            }
            this.postLoginHandler.handleOfflinePlayer(player, playerIp);
        }
        catch (Exception e) {
            this.logger.error("B\u0142\u0105d podczas obs\u0142ugi PostLoginEvent dla gracza: {}", (Object)event.getPlayer().getUsername(), (Object)e);
            event.getPlayer().disconnect((Component)Component.text((String)"Wyst\u0105pi\u0142 b\u0142\u0105d podczas \u0142\u0105czenia. Spr\u00f3buj ponownie.", (TextColor)NamedTextColor.RED));
        }
    }

    @Subscribe(priority=32767)
    public void onServerPreConnect(ServerPreConnectEvent event) {
        try {
            Player player = event.getPlayer();
            String targetServerName = event.getOriginalServer().getServerInfo().getName();
            String playerIp = PlayerAddressUtils.getPlayerIp(player);
            this.logger.debug("ServerPreConnectEvent dla gracza {} -> serwer {}", (Object)player.getUsername(), (Object)targetServerName);
            if (targetServerName.equals(this.settings.getPicoLimboServerName())) {
                boolean isAuthorized = this.authCache.isPlayerAuthorized(player.getUniqueId(), playerIp);
                if (isAuthorized) {
                    this.logger.debug("Autoryzowany gracz {} pr\u00f3buje i\u015b\u0107 na PicoLimbo - przekierowuj\u0119 na backend", (Object)player.getUsername());
                    event.setResult(ServerPreConnectEvent.ServerResult.denied());
                    return;
                }
                this.logger.debug("PicoLimbo - pozw\u00f3l (gracz nie jest autoryzowany)");
                return;
            }
            boolean isAuthorized = this.authCache.isPlayerAuthorized(player.getUniqueId(), playerIp);
            boolean hasActiveSession = this.authCache.hasActiveSession(player.getUniqueId(), player.getUsername(), PlayerAddressUtils.getPlayerIp(player));
            boolean uuidMatches = this.verifyPlayerUuid(player);
            if (!(isAuthorized && hasActiveSession && uuidMatches)) {
                String reason = AuthListener.resolveBlockReason(isAuthorized, hasActiveSession);
                if (this.logger.isWarnEnabled()) {
                    this.logger.warn(SECURITY_MARKER, this.messages.get("player.blocked.unauthorized", new Object[0]), player.getUsername(), targetServerName, reason, playerIp);
                }
                event.setResult(ServerPreConnectEvent.ServerResult.denied());
                player.sendMessage((Component)((TextComponent.Builder)((TextComponent.Builder)Component.text().content("\u274c ").color((TextColor)NamedTextColor.RED)).append(Component.text((String)"Musisz si\u0119 zalogowa\u0107 na auth!").color((TextColor)NamedTextColor.RED))).build());
                if (!uuidMatches) {
                    this.authCache.removeAuthorizedPlayer(player.getUniqueId());
                    this.authCache.endSession(player.getUniqueId());
                }
                return;
            }
            this.logger.debug("\u2705 Autoryzowany gracz {} idzie na {} (sesja: OK, UUID: OK)", (Object)player.getUsername(), (Object)targetServerName);
        }
        catch (Exception e) {
            this.logger.error("B\u0142\u0105d w ServerPreConnect", e);
            event.setResult(ServerPreConnectEvent.ServerResult.denied());
        }
    }

    @Subscribe(priority=-200)
    public void onServerConnected(ServerConnectedEvent event) {
        try {
            Player player = event.getPlayer();
            String serverName = event.getServer().getServerInfo().getName();
            this.logger.debug("ServerConnectedEvent dla gracza {} -> serwer {}", (Object)player.getUsername(), (Object)serverName);
            if (!serverName.equals(this.settings.getPicoLimboServerName())) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(AUTH_MARKER, this.messages.get("player.connected.backend", new Object[0]), (Object)player.getUsername(), (Object)serverName);
                }
                player.sendMessage((Component)Component.text((String)"Witaj na serwerze! Mi\u0142ej gry!", (TextColor)NamedTextColor.GREEN));
            } else {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(AUTH_MARKER, "Gracz {} po\u0142\u0105czy\u0142 si\u0119 z PicoLimbo", (Object)player.getUsername());
                }
                player.sendMessage((Component)Component.text((String)"=== Autoryzacja VeloAuth ===", (TextColor)NamedTextColor.GOLD));
                player.sendMessage((Component)Component.text((String)"Je\u015bli masz konto: /login <has\u0142o>", (TextColor)NamedTextColor.YELLOW));
                player.sendMessage((Component)Component.text((String)"Je\u015bli nie masz konta: /register <has\u0142o> <powt\u00f3rz>", (TextColor)NamedTextColor.YELLOW));
            }
        }
        catch (Exception e) {
            this.logger.error("B\u0142\u0105d podczas obs\u0142ugi ServerConnectedEvent", e);
        }
    }

    private boolean verifyPlayerUuid(Player player) {
        try {
            if (player.isOnlineMode()) {
                return this.handlePremiumPlayer(player);
            }
            return this.verifyCrackedPlayerUuid(player);
        }
        catch (Exception e) {
            return this.handleVerificationError(player, e);
        }
    }

    private boolean handlePremiumPlayer(Player player) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Premium gracz {} - pomijam weryfikacj\u0119 UUID z baz\u0105", (Object)player.getUsername());
        }
        return true;
    }

    private boolean verifyCrackedPlayerUuid(Player player) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                DatabaseManager.DbResult<RegisteredPlayer> dbResult = this.databaseManager.findPlayerByNickname(player.getUsername()).join();
                if (dbResult.isDatabaseError()) {
                    return this.handleDatabaseVerificationError(player, dbResult);
                }
                return this.performUuidVerification(player, dbResult.getValue());
            }
            catch (Exception e) {
                return this.handleAsyncVerificationError(player, e);
            }
        }).join();
    }

    private boolean handleDatabaseVerificationError(Player player, DatabaseManager.DbResult<RegisteredPlayer> dbResult) {
        this.logger.error(SECURITY_MARKER, "[DATABASE ERROR] UUID verification failed for {}: {}", (Object)player.getUsername(), (Object)dbResult.getErrorMessage());
        AuthenticationErrorHandler.handleVerificationFailure(player, player.getUniqueId(), this.authCache, this.logger);
        return false;
    }

    private boolean performUuidVerification(Player player, RegisteredPlayer dbPlayer) {
        if (dbPlayer == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Brak UUID w bazie dla gracza {}", (Object)player.getUsername());
            }
            return false;
        }
        UUID playerUuid = player.getUniqueId();
        if (dbPlayer.getConflictMode()) {
            this.logger.info(SECURITY_MARKER, "[CONFLICT_MODE ACTIVE] Player {} (UUID: {}) is in conflict resolution mode - allowing access despite potential UUID mismatch. Conflict timestamp: {}", player.getUsername(), playerUuid, dbPlayer.getConflictTimestamp() > 0L ? Instant.ofEpochMilli(dbPlayer.getConflictTimestamp()) : "not set");
            return true;
        }
        UUID storedUuid = this.parseUuid(dbPlayer.getUuid());
        UUID storedPremiumUuid = this.parseUuid(dbPlayer.getPremiumUuid());
        if (storedUuid != null && playerUuid.equals(storedUuid)) {
            return true;
        }
        if (storedPremiumUuid != null && playerUuid.equals(storedPremiumUuid)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("UUID matched against PREMIUMUUID for player {}", (Object)player.getUsername());
            }
            return true;
        }
        this.handleUuidMismatch(player, playerUuid, storedUuid, storedPremiumUuid, dbPlayer);
        return false;
    }

    private UUID parseUuid(String uuidString) {
        if (uuidString == null || uuidString.isEmpty()) {
            return null;
        }
        try {
            return UUID.fromString(uuidString);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private void handleUuidMismatch(Player player, UUID playerUuid, UUID storedUuid, UUID storedPremiumUuid, RegisteredPlayer dbPlayer) {
        AuthenticationErrorHandler.handleUuidMismatch(player, playerUuid, storedUuid, storedPremiumUuid, dbPlayer, this.authCache, this.logger);
    }

    private boolean handleAsyncVerificationError(Player player, Exception e) {
        return AuthenticationErrorHandler.handleVerificationError(player, e, this.authCache, this.logger);
    }

    private boolean handleVerificationError(Player player, Exception e) {
        return AuthenticationErrorHandler.handleVerificationError(player, e, this.authCache, this.logger);
    }
}

