/*
 * Decompiled with CFR 0.152.
 */
package net.rafalohaki.veloauth.listener;

import com.velocitypowered.api.proxy.Player;
import java.util.Optional;
import java.util.UUID;
import net.kyori.adventure.text.BuildableComponent;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.rafalohaki.veloauth.VeloAuth;
import net.rafalohaki.veloauth.cache.AuthCache;
import net.rafalohaki.veloauth.connection.ConnectionManager;
import net.rafalohaki.veloauth.database.DatabaseManager;
import net.rafalohaki.veloauth.i18n.Messages;
import net.rafalohaki.veloauth.model.CachedAuthUser;
import net.rafalohaki.veloauth.model.RegisteredPlayer;
import org.slf4j.Logger;

public class PostLoginHandler {
    private final VeloAuth plugin;
    private final AuthCache authCache;
    private final ConnectionManager connectionManager;
    private final DatabaseManager databaseManager;
    private final Messages messages;
    private final Logger logger;

    public PostLoginHandler(VeloAuth plugin, AuthCache authCache, ConnectionManager connectionManager, DatabaseManager databaseManager, Messages messages, Logger logger) {
        this.plugin = plugin;
        this.authCache = authCache;
        this.connectionManager = connectionManager;
        this.databaseManager = databaseManager;
        this.messages = messages;
        this.logger = logger;
    }

    public void handlePremiumPlayer(Player player, String playerIp) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info(this.messages.get("player.premium.verified", new Object[0]), (Object)player.getUsername());
        }
        UUID playerUuid = player.getUniqueId();
        UUID premiumUuid = Optional.ofNullable(this.authCache.getPremiumStatus(player.getUsername())).map(AuthCache.PremiumCacheEntry::getPremiumUuid).orElse(playerUuid);
        CachedAuthUser cachedUser = new CachedAuthUser(playerUuid, player.getUsername(), playerIp, System.currentTimeMillis(), true, premiumUuid);
        this.authCache.addAuthorizedPlayer(playerUuid, cachedUser);
        this.authCache.startSession(playerUuid, player.getUsername(), playerIp);
    }

    public void handleOfflinePlayer(Player player, String playerIp) {
        if (this.authCache.isPlayerAuthorized(player.getUniqueId(), playerIp)) {
            this.logger.info("\u2705 Gracz {} jest ju\u017c autoryzowany - pozostaje na backendzie", (Object)player.getUsername());
            return;
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info(this.messages.get("player.unauthorized.redirect", new Object[0]), (Object)player.getUsername());
        }
        this.transferToPicoLimboAsync(player);
    }

    public void showConflictResolutionMessage(Player player) {
        BuildableComponent message = ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text((String)this.messages.get("player.conflict.header", new Object[0]), (TextColor)NamedTextColor.YELLOW))).append((Component)Component.newline())).append((Component)Component.text((String)this.messages.get("player.conflict.description", new Object[0]), (TextColor)NamedTextColor.RED))).append((Component)Component.newline())).append((Component)Component.text((String)this.messages.get("player.conflict.options", new Object[0]), (TextColor)NamedTextColor.WHITE))).append((Component)Component.newline())).append((Component)Component.text((String)this.messages.get("player.conflict.option1", new Object[0]), (TextColor)NamedTextColor.GRAY))).append((Component)Component.newline())).append((Component)Component.text((String)this.messages.get("player.conflict.option2", new Object[0]), (TextColor)NamedTextColor.GREEN))).append((Component)Component.newline())).append((Component)Component.text((String)this.messages.get("player.conflict.resolution", new Object[0]), (TextColor)NamedTextColor.AQUA))).build();
        player.sendMessage((Component)message);
        this.logger.info("[CONFLICT MESSAGE] Sent conflict resolution message to premium player: {}", (Object)player.getUsername());
    }

    public boolean shouldShowConflictMessage(Player player) {
        RegisteredPlayer registeredPlayer = this.databaseManager.findPlayerWithRuntimeDetection(player.getUsername()).join().getValue();
        if (registeredPlayer == null || !registeredPlayer.getConflictMode()) {
            return false;
        }
        return Optional.ofNullable(this.authCache.getPremiumStatus(player.getUsername())).map(AuthCache.PremiumCacheEntry::isPremium).orElse(false);
    }

    private void transferToPicoLimboAsync(Player player) {
        this.plugin.getServer().getScheduler().buildTask((Object)this.plugin, () -> {
            try {
                boolean success = this.connectionManager.transferToPicoLimbo(player);
                if (!success) {
                    this.logger.error("\u274c B\u0142\u0105d podczas przenoszenia gracza {} na PicoLimbo", (Object)player.getUsername());
                    player.disconnect((Component)Component.text((String)"Nie uda\u0142o si\u0119 po\u0142\u0105czy\u0107 z serwerem autoryzacji. Spr\u00f3buj ponownie.", (TextColor)NamedTextColor.RED));
                }
            }
            catch (Exception e) {
                this.logger.error("\u274c B\u0142\u0105d podczas przenoszenia gracza {} na PicoLimbo: {}", player.getUsername(), e.getMessage(), e);
                player.disconnect((Component)Component.text((String)"Wyst\u0105pi\u0142 b\u0142\u0105d podczas \u0142\u0105czenia z serwerem autoryzacji. Spr\u00f3buj ponownie.", (TextColor)NamedTextColor.RED));
            }
        }).schedule();
    }
}

