/*
 * Decompiled with CFR 0.152.
 */
package net.rafalohaki.veloauth.listener;

import com.velocitypowered.api.event.connection.PreLoginEvent;
import java.net.InetAddress;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import net.rafalohaki.veloauth.cache.AuthCache;
import net.rafalohaki.veloauth.database.DatabaseManager;
import net.rafalohaki.veloauth.i18n.Messages;
import net.rafalohaki.veloauth.model.RegisteredPlayer;
import net.rafalohaki.veloauth.premium.PremiumResolution;
import net.rafalohaki.veloauth.premium.PremiumResolverService;
import net.rafalohaki.veloauth.util.VirtualThreadExecutorProvider;
import org.slf4j.Logger;

public class PreLoginHandler {
    private final AuthCache authCache;
    private final PremiumResolverService premiumResolverService;
    private final DatabaseManager databaseManager;
    private final Messages messages;
    private final Logger logger;

    public PreLoginHandler(AuthCache authCache, PremiumResolverService premiumResolverService, DatabaseManager databaseManager, Messages messages, Logger logger) {
        this.authCache = authCache;
        this.premiumResolverService = premiumResolverService;
        this.databaseManager = databaseManager;
        this.messages = messages;
        this.logger = logger;
    }

    public boolean isValidUsername(String username) {
        if (username == null || username.isEmpty()) {
            return false;
        }
        if (username.length() < 3 || username.length() > 16) {
            return false;
        }
        for (int i = 0; i < username.length(); ++i) {
            char c = username.charAt(i);
            if (Character.isLetterOrDigit(c) || c == '_') continue;
            return false;
        }
        return true;
    }

    public boolean isBruteForceBlocked(InetAddress address) {
        if (address == null) {
            return false;
        }
        return this.authCache.isBlocked(address);
    }

    public PremiumResolutionResult resolvePremiumStatus(String username) {
        AuthCache.PremiumCacheEntry cachedStatus = this.authCache.getPremiumStatus(username);
        if (cachedStatus != null) {
            this.logger.debug("Premium cache hit dla {} -> {} (age: {}ms, TTL: {}ms)", username, cachedStatus.isPremium(), cachedStatus.getAgeMillis(), cachedStatus.getTtlMillis());
            if (cachedStatus.isStale()) {
                this.triggerBackgroundRefresh(username);
            }
            return new PremiumResolutionResult(cachedStatus.isPremium(), cachedStatus.getPremiumUuid());
        }
        PremiumResolution resolution = this.resolveViaServiceWithTimeout(username);
        return this.cacheFromResolution(username, resolution);
    }

    private void triggerBackgroundRefresh(String username) {
        try {
            CompletableFuture.runAsync(() -> {
                this.logger.debug("Background refresh of premium status for {}", (Object)username);
                try {
                    PremiumResolution resolution = this.premiumResolverService.resolve(username);
                    this.cacheFromResolution(username, resolution);
                    this.logger.debug("Background refresh completed for {}", (Object)username);
                }
                catch (Exception e) {
                    this.logger.warn("Background refresh failed for {}: {}", (Object)username, (Object)e.getMessage());
                }
            }, VirtualThreadExecutorProvider.getVirtualExecutor());
        }
        catch (Exception e) {
            this.logger.warn("Failed to trigger background refresh for {}: {}", (Object)username, (Object)e.getMessage());
        }
    }

    public boolean isNicknameConflict(RegisteredPlayer existingPlayer, boolean isPremium, boolean existingIsPremium) {
        return isPremium && !existingIsPremium || !isPremium && existingPlayer.getConflictMode();
    }

    public void handleNicknameConflict(PreLoginEvent event, RegisteredPlayer existingPlayer, boolean isPremium) {
        String username = event.getUsername();
        if (isPremium && existingPlayer.getPremiumUuid() == null) {
            if (!existingPlayer.getConflictMode()) {
                existingPlayer.setConflictMode(true);
                existingPlayer.setConflictTimestamp(System.currentTimeMillis());
                existingPlayer.setOriginalNickname(existingPlayer.getNickname());
                this.databaseManager.savePlayer(existingPlayer).join();
                this.logger.info("[NICKNAME CONFLICT] Premium player {} detected conflict with offline account", (Object)username);
            }
            event.setResult(PreLoginEvent.PreLoginComponentResult.forceOfflineMode());
        } else if (!isPremium && existingPlayer.getConflictMode()) {
            event.setResult(PreLoginEvent.PreLoginComponentResult.forceOfflineMode());
            this.logger.debug("[NICKNAME CONFLICT] Offline player {} accessing conflicted account", (Object)username);
        }
    }

    public void handleNicknameConflictNoEvent(String username, RegisteredPlayer existingPlayer, boolean isPremium) {
        if (isPremium && existingPlayer.getPremiumUuid() == null) {
            if (!existingPlayer.getConflictMode()) {
                existingPlayer.setConflictMode(true);
                existingPlayer.setConflictTimestamp(System.currentTimeMillis());
                existingPlayer.setOriginalNickname(existingPlayer.getNickname());
                this.databaseManager.savePlayer(existingPlayer).join();
                this.logger.info("[NICKNAME CONFLICT] Premium player {} detected conflict with offline account", (Object)username);
            }
        } else if (!isPremium && existingPlayer.getConflictMode()) {
            this.logger.debug("[NICKNAME CONFLICT] Offline player {} accessing conflicted account", (Object)username);
        }
    }

    private PremiumResolution resolveViaServiceWithTimeout(String username) {
        try {
            return (PremiumResolution)((CompletableFuture)CompletableFuture.supplyAsync(() -> this.premiumResolverService.resolve(username)).orTimeout(3L, TimeUnit.SECONDS).exceptionally(throwable -> PremiumResolution.offline(username, "VeloAuth-Timeout", "Timeout - fallback to offline"))).join();
        }
        catch (Exception e) {
            return PremiumResolution.offline(username, "VeloAuth-Error", "Error - fallback to offline");
        }
    }

    private PremiumResolutionResult cacheFromResolution(String username, PremiumResolution resolution) {
        if (resolution.isPremium()) {
            UUID premiumUuid = resolution.uuid();
            String canonical = resolution.canonicalUsername() != null ? resolution.canonicalUsername() : username;
            this.authCache.addPremiumPlayer(canonical, premiumUuid);
            if (this.logger.isInfoEnabled()) {
                this.logger.info(this.messages.get("player.premium.confirmed", new Object[0]), username, resolution.source(), premiumUuid);
            }
            return new PremiumResolutionResult(true, premiumUuid);
        }
        if (resolution.isOffline()) {
            this.authCache.addPremiumPlayer(username, null);
            this.logger.debug("{} nie jest premium (resolver: {}, info: {})", username, resolution.source(), resolution.message());
            return new PremiumResolutionResult(false, null);
        }
        this.logger.warn("\u26a0\ufe0f Nie uda\u0142o si\u0119 jednoznacznie potwierdzi\u0107 statusu premium dla {} (resolver: {}, info: {})", username, resolution.source(), resolution.message());
        return new PremiumResolutionResult(false, null);
    }

    public record PremiumResolutionResult(boolean premium, UUID premiumUuid) {
    }
}

