/*
 * Decompiled with CFR 0.152.
 */
package net.rafalohaki.veloauth.model;

import java.util.Objects;
import java.util.UUID;
import net.rafalohaki.veloauth.model.RegisteredPlayer;

public final class CachedAuthUser {
    private final UUID uuid;
    private final String nickname;
    private final String loginIp;
    private final long cacheTime;
    private final long loginTime;
    private final boolean isPremium;
    private final UUID premiumUuid;

    public CachedAuthUser(UUID uuid, String nickname, String loginIp, long loginTime, boolean isPremium, UUID premiumUuid) {
        if (uuid == null) {
            throw new IllegalArgumentException("UUID nie mo\u017ce by\u0107 null");
        }
        if (nickname == null || nickname.isEmpty()) {
            throw new IllegalArgumentException("Nickname nie mo\u017ce by\u0107 pusty");
        }
        this.uuid = uuid;
        this.nickname = nickname;
        this.loginIp = loginIp;
        this.loginTime = loginTime;
        this.isPremium = isPremium;
        this.premiumUuid = premiumUuid;
        this.cacheTime = System.currentTimeMillis();
    }

    public static CachedAuthUser fromRegisteredPlayer(RegisteredPlayer player, boolean isPremium) {
        if (player == null) {
            throw new IllegalArgumentException("Player nie mo\u017ce by\u0107 null");
        }
        UUID uuid = player.getUuidAsUUID();
        if (uuid == null) {
            throw new IllegalArgumentException("Player musi mie\u0107 prawid\u0142owy UUID");
        }
        return new CachedAuthUser(uuid, player.getNickname(), player.getLoginIp(), player.getLoginDate(), isPremium, null);
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public String getNickname() {
        return this.nickname;
    }

    public String getLoginIp() {
        return this.loginIp;
    }

    public long getCacheTime() {
        return this.cacheTime;
    }

    public long getLoginTime() {
        return this.loginTime;
    }

    public boolean isPremium() {
        return this.isPremium;
    }

    public UUID getPremiumUuid() {
        return this.premiumUuid;
    }

    public boolean isValid(int ttlMinutes) {
        if (ttlMinutes <= 0) {
            return true;
        }
        long ttlMillis = (long)ttlMinutes * 60L * 1000L;
        long currentTime = System.currentTimeMillis();
        return currentTime - this.cacheTime < ttlMillis;
    }

    public boolean matchesIp(String currentIp) {
        if (this.loginIp == null || currentIp == null) {
            return true;
        }
        return this.loginIp.equals(currentIp);
    }

    public long getCacheAgeMinutes() {
        long currentTime = System.currentTimeMillis();
        return (currentTime - this.cacheTime) / 60000L;
    }

    public CachedAuthUser withUpdatedIp(String newLoginIp) {
        return new CachedAuthUser(this.uuid, this.nickname, newLoginIp, System.currentTimeMillis(), this.isPremium, this.premiumUuid);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        CachedAuthUser that = (CachedAuthUser)obj;
        return Objects.equals(this.uuid, that.uuid) && Objects.equals(this.nickname, that.nickname);
    }

    public int hashCode() {
        return Objects.hash(this.uuid, this.nickname);
    }

    public String toString() {
        return "CachedAuthUser{uuid=" + String.valueOf(this.uuid) + ", nickname='" + this.nickname + "', loginIp='" + this.loginIp + "', cacheTime=" + this.cacheTime + ", loginTime=" + this.loginTime + ", isPremium=" + this.isPremium + ", premiumUuid=" + String.valueOf(this.premiumUuid) + ", cacheAgeMinutes=" + this.getCacheAgeMinutes() + "}";
    }
}

