/*
 * Decompiled with CFR 0.152.
 */
package net.rafalohaki.veloauth.model;

import java.util.Objects;
import java.util.UUID;
import net.rafalohaki.veloauth.libs.ormlite.field.DatabaseField;
import net.rafalohaki.veloauth.libs.ormlite.table.DatabaseTable;

@DatabaseTable(tableName="PREMIUM_UUIDS")
public class PremiumUuid {
    @DatabaseField(columnName="UUID", id=true)
    private String uuid;
    @DatabaseField(columnName="NICKNAME")
    private String nickname;
    @DatabaseField(columnName="LAST_SEEN")
    private long lastSeen;
    @DatabaseField(columnName="VERIFIED_AT")
    private long verifiedAt;

    public PremiumUuid() {
    }

    public PremiumUuid(UUID uuid, String nickname) {
        this.uuid = uuid.toString();
        this.nickname = nickname;
        this.lastSeen = System.currentTimeMillis();
        this.verifiedAt = System.currentTimeMillis();
    }

    public PremiumUuid(String uuid, String nickname) {
        this.uuid = uuid;
        this.nickname = nickname;
        this.lastSeen = System.currentTimeMillis();
        this.verifiedAt = System.currentTimeMillis();
    }

    public void updateNickname(String newNickname) {
        this.nickname = newNickname;
        this.lastSeen = System.currentTimeMillis();
    }

    public void updateLastSeen() {
        this.lastSeen = System.currentTimeMillis();
    }

    public boolean isExpired(long ttlMinutes) {
        long ttlMillis = ttlMinutes * 60L * 1000L;
        return System.currentTimeMillis() - this.lastSeen > ttlMillis;
    }

    public UUID getUuid() {
        if (this.uuid == null || this.uuid.isEmpty()) {
            return null;
        }
        try {
            return UUID.fromString(this.uuid);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public String getUuidString() {
        return this.uuid;
    }

    public String getNickname() {
        return this.nickname;
    }

    public void setNickname(String nickname) {
        this.nickname = nickname;
    }

    public long getLastSeen() {
        return this.lastSeen;
    }

    public void setLastSeen(long lastSeen) {
        this.lastSeen = lastSeen;
    }

    public long getVerifiedAt() {
        return this.verifiedAt;
    }

    public void setVerifiedAt(long verifiedAt) {
        this.verifiedAt = verifiedAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PremiumUuid that = (PremiumUuid)o;
        return Objects.equals(this.uuid, that.uuid);
    }

    public int hashCode() {
        return Objects.hash(this.uuid);
    }

    public String toString() {
        return "PremiumUuid{uuid='" + this.uuid + "', nickname='" + this.nickname + "', lastSeen=" + this.lastSeen + ", verifiedAt=" + this.verifiedAt + "}";
    }
}

