/*
 * Decompiled with CFR 0.152.
 */
package net.rafalohaki.veloauth.model;

import java.util.Objects;
import java.util.UUID;
import net.rafalohaki.veloauth.libs.ormlite.field.DatabaseField;
import net.rafalohaki.veloauth.libs.ormlite.table.DatabaseTable;

@DatabaseTable(tableName="AUTH")
public class RegisteredPlayer {
    @DatabaseField(columnName="NICKNAME", canBeNull=false)
    private String nickname;
    @DatabaseField(columnName="LOWERCASENICKNAME", id=true, canBeNull=false)
    private String lowercaseNickname;
    @DatabaseField(columnName="HASH")
    private String hash;
    @DatabaseField(columnName="IP")
    private String ip;
    @DatabaseField(columnName="REGDATE")
    private long regDate;
    @DatabaseField(columnName="UUID")
    private String uuid;
    @DatabaseField(columnName="LOGINIP")
    private String loginIp;
    @DatabaseField(columnName="LOGINDATE")
    private long loginDate;
    @DatabaseField(columnName="PREMIUMUUID")
    private String premiumUuid;
    @DatabaseField(columnName="TOTPTOKEN")
    private String totpToken;
    @DatabaseField(columnName="ISSUEDTIME")
    private long issuedTime;
    @DatabaseField(columnName="CONFLICT_MODE")
    private boolean conflictMode;
    @DatabaseField(columnName="CONFLICT_TIMESTAMP")
    private long conflictTimestamp;
    @DatabaseField(columnName="ORIGINAL_NICKNAME")
    private String originalNickname;

    public RegisteredPlayer() {
    }

    public RegisteredPlayer(String nickname, String hash, String ip, String uuid) {
        long currentTime;
        if (nickname == null || nickname.isEmpty()) {
            throw new IllegalArgumentException("Nickname nie mo\u017ce by\u0107 pusty");
        }
        this.nickname = nickname;
        this.lowercaseNickname = nickname.toLowerCase();
        this.hash = hash;
        this.ip = ip;
        this.uuid = uuid;
        this.loginIp = ip;
        this.regDate = currentTime = System.currentTimeMillis();
        this.loginDate = currentTime;
    }

    public String getNickname() {
        return this.nickname;
    }

    public void setNickname(String nickname) {
        if (nickname == null || nickname.isEmpty()) {
            throw new IllegalArgumentException("Nickname nie mo\u017ce by\u0107 pusty");
        }
        this.nickname = nickname;
        this.lowercaseNickname = nickname.toLowerCase();
    }

    public String getLowercaseNickname() {
        return this.lowercaseNickname;
    }

    public String getHash() {
        return this.hash;
    }

    public void setHash(String hash) {
        this.hash = hash;
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public String getLoginIp() {
        return this.loginIp;
    }

    public void setLoginIp(String loginIp) {
        this.loginIp = loginIp;
    }

    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public long getRegDate() {
        return this.regDate;
    }

    public void setRegDate(long regDate) {
        this.regDate = regDate;
    }

    public long getLoginDate() {
        return this.loginDate;
    }

    public void setLoginDate(long loginDate) {
        this.loginDate = loginDate;
    }

    public String getPremiumUuid() {
        return this.premiumUuid;
    }

    public void setPremiumUuid(String premiumUuid) {
        this.premiumUuid = premiumUuid;
    }

    public String getTotpToken() {
        return this.totpToken;
    }

    public void setTotpToken(String totpToken) {
        this.totpToken = totpToken;
    }

    public long getIssuedTime() {
        return this.issuedTime;
    }

    public void setIssuedTime(long issuedTime) {
        this.issuedTime = issuedTime;
    }

    public boolean getConflictMode() {
        return this.conflictMode;
    }

    public void setConflictMode(boolean conflictMode) {
        this.conflictMode = conflictMode;
    }

    public long getConflictTimestamp() {
        return this.conflictTimestamp;
    }

    public void setConflictTimestamp(long conflictTimestamp) {
        this.conflictTimestamp = conflictTimestamp;
    }

    public String getOriginalNickname() {
        return this.originalNickname;
    }

    public void setOriginalNickname(String originalNickname) {
        this.originalNickname = originalNickname;
    }

    public void updateLoginData(String loginIp) {
        this.loginIp = loginIp;
        this.loginDate = System.currentTimeMillis();
    }

    public UUID getUuidAsUUID() {
        if (this.uuid == null || this.uuid.isEmpty()) {
            return null;
        }
        try {
            return UUID.fromString(this.uuid);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RegisteredPlayer that = (RegisteredPlayer)obj;
        return Objects.equals(this.lowercaseNickname, that.lowercaseNickname);
    }

    public int hashCode() {
        return Objects.hash(this.lowercaseNickname);
    }

    public String toString() {
        return "RegisteredPlayer{nickname='" + this.nickname + "', lowercaseNickname='" + this.lowercaseNickname + "', ip='" + this.ip + "', loginIp='" + this.loginIp + "', uuid='" + this.uuid + "', regDate=" + this.regDate + ", loginDate=" + this.loginDate + ", isPremium=" + (this.premiumUuid != null) + "}";
    }
}

