/*
 * Decompiled with CFR 0.152.
 */
package net.rafalohaki.veloauth.monitoring;

import java.util.concurrent.atomic.AtomicLong;
import net.rafalohaki.veloauth.VeloAuth;
import net.rafalohaki.veloauth.cache.AuthCache;
import net.rafalohaki.veloauth.database.DatabaseManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricsCollector {
    private static final Logger logger = LoggerFactory.getLogger(MetricsCollector.class);
    private final VeloAuth plugin;
    private final DatabaseManager databaseManager;
    private final AuthCache authCache;
    private final AtomicLong loginAttempts = new AtomicLong(0L);
    private final AtomicLong successfulLogins = new AtomicLong(0L);
    private final AtomicLong failedLogins = new AtomicLong(0L);
    private final AtomicLong registrationAttempts = new AtomicLong(0L);
    private final AtomicLong successfulRegistrations = new AtomicLong(0L);
    private final AtomicLong passwordChanges = new AtomicLong(0L);
    private final AtomicLong bruteForceBlocks = new AtomicLong(0L);
    private final AtomicLong premiumChecks = new AtomicLong(0L);
    private volatile long lastDatabaseHealthCheck = 0L;
    private volatile boolean databaseHealthy = false;

    public MetricsCollector(VeloAuth plugin, DatabaseManager databaseManager, AuthCache authCache) {
        this.plugin = plugin;
        this.databaseManager = databaseManager;
        this.authCache = authCache;
    }

    public void incrementLoginAttempts() {
        this.loginAttempts.incrementAndGet();
    }

    public void incrementSuccessfulLogins() {
        this.successfulLogins.incrementAndGet();
    }

    public void incrementFailedLogins() {
        this.failedLogins.incrementAndGet();
    }

    public void incrementRegistrationAttempts() {
        this.registrationAttempts.incrementAndGet();
    }

    public void incrementSuccessfulRegistrations() {
        this.successfulRegistrations.incrementAndGet();
    }

    public void incrementPasswordChanges() {
        this.passwordChanges.incrementAndGet();
    }

    public void incrementBruteForceBlocks() {
        this.bruteForceBlocks.incrementAndGet();
    }

    public void incrementPremiumChecks() {
        this.premiumChecks.incrementAndGet();
    }

    public void updateDatabaseHealth(boolean healthy) {
        this.databaseHealthy = healthy;
        this.lastDatabaseHealthCheck = System.currentTimeMillis();
    }

    public String generatePrometheusMetrics() {
        StringBuilder metrics = new StringBuilder();
        metrics.append("# HELP veloauth_login_attempts_total Total number of login attempts\n");
        metrics.append("# TYPE veloauth_login_attempts_total counter\n");
        metrics.append("veloauth_login_attempts_total ").append(this.loginAttempts.get()).append("\n\n");
        metrics.append("# HELP veloauth_login_successes_total Total number of successful logins\n");
        metrics.append("# TYPE veloauth_login_successes_total counter\n");
        metrics.append("veloauth_login_successes_total ").append(this.successfulLogins.get()).append("\n\n");
        metrics.append("# HELP veloauth_login_failures_total Total number of failed logins\n");
        metrics.append("# TYPE veloauth_login_failures_total counter\n");
        metrics.append("veloauth_login_failures_total ").append(this.failedLogins.get()).append("\n\n");
        metrics.append("# HELP veloauth_registration_attempts_total Total number of registration attempts\n");
        metrics.append("# TYPE veloauth_registration_attempts_total counter\n");
        metrics.append("veloauth_registration_attempts_total ").append(this.registrationAttempts.get()).append("\n\n");
        metrics.append("# HELP veloauth_registration_successes_total Total number of successful registrations\n");
        metrics.append("# TYPE veloauth_registration_successes_total counter\n");
        metrics.append("veloauth_registration_successes_total ").append(this.successfulRegistrations.get()).append("\n\n");
        metrics.append("# HELP veloauth_password_changes_total Total number of password changes\n");
        metrics.append("# TYPE veloauth_password_changes_total counter\n");
        metrics.append("veloauth_password_changes_total ").append(this.passwordChanges.get()).append("\n\n");
        metrics.append("# HELP veloauth_brute_force_blocks_total Total number of brute force blocks\n");
        metrics.append("# TYPE veloauth_brute_force_blocks_total counter\n");
        metrics.append("veloauth_brute_force_blocks_total ").append(this.bruteForceBlocks.get()).append("\n\n");
        metrics.append("# HELP veloauth_premium_checks_total Total number of premium status checks\n");
        metrics.append("# TYPE veloauth_premium_checks_total counter\n");
        metrics.append("veloauth_premium_checks_total ").append(this.premiumChecks.get()).append("\n\n");
        AuthCache.CacheStats cacheStats = this.authCache.getStats();
        metrics.append("# HELP veloauth_cache_size Current number of entries in authorization cache\n");
        metrics.append("# TYPE veloauth_cache_size gauge\n");
        metrics.append("veloauth_cache_size ").append(cacheStats.authorizedPlayersCount()).append("\n\n");
        metrics.append("# HELP veloauth_cache_max_size Maximum size of authorization cache\n");
        metrics.append("# TYPE veloauth_cache_max_size gauge\n");
        metrics.append("veloauth_cache_max_size ").append(cacheStats.maxSize()).append("\n\n");
        metrics.append("# HELP veloauth_cache_hit_rate Cache hit rate percentage\n");
        metrics.append("# TYPE veloauth_cache_hit_rate gauge\n");
        metrics.append("veloauth_cache_hit_rate ").append(String.format("%.2f", cacheStats.getHitRate())).append("\n\n");
        metrics.append("# HELP veloauth_cache_requests_total Total number of cache requests\n");
        metrics.append("# TYPE veloauth_cache_requests_total counter\n");
        metrics.append("veloauth_cache_requests_total ").append(cacheStats.getTotalRequests()).append("\n\n");
        metrics.append("# HELP veloauth_brute_force_entries Current number of brute force entries\n");
        metrics.append("# TYPE veloauth_brute_force_entries gauge\n");
        metrics.append("veloauth_brute_force_entries ").append(cacheStats.bruteForceEntriesCount()).append("\n\n");
        metrics.append("# HELP veloauth_active_sessions Current number of active sessions\n");
        metrics.append("# TYPE veloauth_active_sessions gauge\n");
        metrics.append("veloauth_active_sessions ").append(this.countActiveSessions()).append("\n\n");
        metrics.append("# HELP veloauth_database_connected Database connection status (1 = connected, 0 = disconnected)\n");
        metrics.append("# TYPE veloauth_database_connected gauge\n");
        metrics.append("veloauth_database_connected ").append(this.databaseManager.isConnected() ? 1 : 0).append("\n\n");
        metrics.append("# HELP veloauth_database_healthy Database health status (1 = healthy, 0 = unhealthy)\n");
        metrics.append("# TYPE veloauth_database_healthy gauge\n");
        metrics.append("veloauth_database_healthy ").append(this.databaseHealthy ? 1 : 0).append("\n\n");
        metrics.append("# HELP veloauth_database_last_health_check_timestamp Timestamp of last database health check (Unix epoch milliseconds)\n");
        metrics.append("# TYPE veloauth_database_last_health_check_timestamp gauge\n");
        metrics.append("veloauth_database_last_health_check_timestamp ").append(this.lastDatabaseHealthCheck).append("\n\n");
        metrics.append("# HELP veloauth_database_cache_size Current database cache size\n");
        metrics.append("# TYPE veloauth_database_cache_size gauge\n");
        metrics.append("veloauth_database_cache_size ").append(this.databaseManager.getCacheSize()).append("\n\n");
        Runtime runtime = Runtime.getRuntime();
        metrics.append("# HELP veloauth_jvm_memory_used_bytes Used JVM memory in bytes\n");
        metrics.append("# TYPE veloauth_jvm_memory_used_bytes gauge\n");
        metrics.append("veloauth_jvm_memory_used_bytes ").append(runtime.totalMemory() - runtime.freeMemory()).append("\n\n");
        metrics.append("# HELP veloauth_jvm_memory_max_bytes Maximum JVM memory in bytes\n");
        metrics.append("# TYPE veloauth_jvm_memory_max_bytes gauge\n");
        metrics.append("veloauth_jvm_memory_max_bytes ").append(runtime.maxMemory()).append("\n\n");
        metrics.append("# HELP veloauth_jvm_threads_count Number of active threads\n");
        metrics.append("# TYPE veloauth_jvm_threads_count gauge\n");
        metrics.append("veloauth_jvm_threads_count ").append(Thread.activeCount()).append("\n\n");
        metrics.append("# HELP veloauth_plugin_info Plugin version and build info\n");
        metrics.append("# TYPE veloauth_plugin_info gauge\n");
        metrics.append("veloauth_plugin_info{version=\"").append(this.plugin.getVersion()).append("\",java_version=\"").append(System.getProperty("java.version")).append("\"} 1\n\n");
        return metrics.toString();
    }

    private int countActiveSessions() {
        return this.authCache.getStats().authorizedPlayersCount();
    }

    public void resetMetrics() {
        this.loginAttempts.set(0L);
        this.successfulLogins.set(0L);
        this.failedLogins.set(0L);
        this.registrationAttempts.set(0L);
        this.successfulRegistrations.set(0L);
        this.passwordChanges.set(0L);
        this.bruteForceBlocks.set(0L);
        this.premiumChecks.set(0L);
        if (logger.isInfoEnabled()) {
            logger.info("VeloAuth metrics reset");
        }
    }

    public String getMetricsSummary() {
        return String.format("VeloAuth Metrics - Login: %d/%d/%d (attempts/success/fail), Registration: %d/%d (attempts/success), Security: %d brute blocks, %d premium checks, Cache: %d/%d entries (%.1f%% hit rate), DB: %s", this.loginAttempts.get(), this.successfulLogins.get(), this.failedLogins.get(), this.registrationAttempts.get(), this.successfulRegistrations.get(), this.bruteForceBlocks.get(), this.premiumChecks.get(), this.authCache.getStats().authorizedPlayersCount(), this.authCache.getStats().maxSize(), this.authCache.getStats().getHitRate(), this.databaseManager.isConnected() ? "connected" : "disconnected");
    }
}

