/*
 * Decompiled with CFR 0.152.
 */
package net.rafalohaki.veloauth.premium;

import java.util.UUID;
import net.rafalohaki.veloauth.premium.AbstractPremiumResolver;
import net.rafalohaki.veloauth.premium.HttpJsonClient;
import net.rafalohaki.veloauth.premium.PremiumUuidFormatter;
import net.rafalohaki.veloauth.premium.ResolverConfig;
import org.slf4j.Logger;

class ConfigurablePremiumResolver
extends AbstractPremiumResolver {
    private final ResolverConfig config;

    ConfigurablePremiumResolver(Logger logger, boolean enabled, int timeoutMs, ResolverConfig config) {
        super(logger, enabled, timeoutMs);
        this.config = config;
    }

    @Override
    public String id() {
        return this.config.id();
    }

    @Override
    protected String getEndpoint() {
        return this.config.endpoint();
    }

    @Override
    protected boolean isNotFoundResponse(int code) {
        return code == this.config.notFoundResponseCode();
    }

    @Override
    protected String extractUuidField(String responseBody) {
        return HttpJsonClient.extractStringField(responseBody, this.config.uuidField());
    }

    @Override
    protected String extractUsernameField(String responseBody) {
        return HttpJsonClient.extractStringField(responseBody, this.config.usernameField());
    }

    @Override
    protected UUID parseUuid(String uuidStr) {
        if (this.config.usesRawUuidFormat()) {
            UUID uuid = PremiumUuidFormatter.parseRaw32Uuid(uuidStr);
            return uuid != null ? uuid : super.parseUuid(uuidStr);
        }
        return super.parseUuid(uuidStr);
    }
}

