/*
 * Decompiled with CFR 0.152.
 */
package net.rafalohaki.veloauth.premium;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;

final class HttpJsonClient {
    private HttpJsonClient() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static HttpJsonResponse get(String endpoint, String username, int timeoutMs) throws IOException {
        String encodedUsername = URLEncoder.encode(username, StandardCharsets.UTF_8);
        URL url = URI.create(endpoint + encodedUsername).toURL();
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("GET");
        connection.setConnectTimeout(timeoutMs);
        connection.setReadTimeout(timeoutMs);
        connection.setUseCaches(false);
        try {
            int status = connection.getResponseCode();
            String body = null;
            if (status == 200) {
                body = HttpJsonClient.readBody(connection);
            }
            HttpJsonResponse httpJsonResponse = new HttpJsonResponse(status, body);
            return httpJsonResponse;
        }
        finally {
            connection.disconnect();
        }
    }

    static String extractStringField(String body, String field) {
        if (body == null || body.isEmpty()) {
            return null;
        }
        String token = "\"" + field + "\"";
        int idx = body.indexOf(token);
        if (idx == -1) {
            return null;
        }
        int colon = body.indexOf(58, idx + token.length());
        if (colon == -1) {
            return null;
        }
        int quoteStart = body.indexOf(34, colon + 1);
        int quoteEnd = body.indexOf(34, quoteStart + 1);
        if (quoteStart == -1 || quoteEnd == -1) {
            return null;
        }
        return body.substring(quoteStart + 1, quoteEnd);
    }

    private static String readBody(HttpURLConnection connection) throws IOException {
        try (InputStream input = connection.getInputStream();){
            String string = new String(input.readAllBytes(), StandardCharsets.UTF_8);
            return string;
        }
    }

    record HttpJsonResponse(int statusCode, String body) {
    }
}

