/*
 * Decompiled with CFR 0.152.
 */
package net.rafalohaki.veloauth.premium;

import java.util.Objects;
import java.util.UUID;

public record PremiumResolution(PremiumStatus status, UUID uuid, String canonicalUsername, String source, String message) {
    public PremiumResolution {
        Objects.requireNonNull(status, "status");
    }

    public static PremiumResolution premium(UUID uuid, String canonicalUsername, String source) {
        return new PremiumResolution(PremiumStatus.PREMIUM, uuid, canonicalUsername, source, null);
    }

    public static PremiumResolution offline(String canonicalUsername, String source, String message) {
        return new PremiumResolution(PremiumStatus.OFFLINE, null, canonicalUsername, source, message);
    }

    public static PremiumResolution unknown(String source, String message) {
        return new PremiumResolution(PremiumStatus.UNKNOWN, null, null, source, message);
    }

    public boolean isPremium() {
        return this.status == PremiumStatus.PREMIUM;
    }

    public boolean isOffline() {
        return this.status == PremiumStatus.OFFLINE;
    }

    public static enum PremiumStatus {
        PREMIUM,
        OFFLINE,
        UNKNOWN;

    }
}

