/*
 * Decompiled with CFR 0.152.
 */
package net.rafalohaki.veloauth.util;

import com.velocitypowered.api.proxy.Player;
import java.util.UUID;
import net.rafalohaki.veloauth.cache.AuthCache;
import net.rafalohaki.veloauth.model.RegisteredPlayer;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public final class AuthenticationErrorHandler {
    private static final Marker SECURITY_MARKER = MarkerFactory.getMarker("SECURITY");

    private AuthenticationErrorHandler() {
    }

    public static void handleVerificationFailure(Player player, UUID uuid, AuthCache authCache, Logger logger) {
        if (logger.isErrorEnabled()) {
            logger.error(SECURITY_MARKER, "[UUID VERIFICATION FAILED] Player: {} (UUID: {})", (Object)player.getUsername(), (Object)uuid);
        }
        authCache.removeAuthorizedPlayer(uuid);
        authCache.endSession(uuid);
    }

    public static void handleUuidMismatch(Player player, UUID playerUuid, UUID storedUuid, UUID storedPremiumUuid, RegisteredPlayer dbPlayer, AuthCache authCache, Logger logger) {
        logger.warn(SECURITY_MARKER, "[UUID MISMATCH DETECTED] Nickname: {}, Connection UUID: {}, DB UUID: {}, DB PREMIUMUUID: {}, ConflictMode: {}, IP: {}", player.getUsername(), playerUuid, storedUuid != null ? storedUuid : "null", storedPremiumUuid != null ? storedPremiumUuid : "null", dbPlayer != null ? Boolean.valueOf(dbPlayer.getConflictMode()) : "unknown", player.getRemoteAddress().getAddress().getHostAddress());
        if (logger.isDebugEnabled()) {
            logger.debug(SECURITY_MARKER, "[CACHE INVALIDATION] Removing player {} (UUID: {}) from cache due to UUID mismatch", (Object)player.getUsername(), (Object)playerUuid);
        }
        authCache.removeAuthorizedPlayer(playerUuid);
        authCache.endSession(playerUuid);
    }

    public static boolean handleVerificationError(Player player, Exception exception, AuthCache authCache, Logger logger) {
        if (logger.isErrorEnabled()) {
            logger.error("B\u0142\u0105d podczas weryfikacji UUID gracza: {}", (Object)player.getUsername(), (Object)exception);
        }
        authCache.removeAuthorizedPlayer(player.getUniqueId());
        authCache.endSession(player.getUniqueId());
        return false;
    }
}

