/*
 * Decompiled with CFR 0.152.
 */
package net.rafalohaki.veloauth.util;

import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.proxy.Player;
import net.rafalohaki.veloauth.command.ValidationUtils;
import net.rafalohaki.veloauth.database.DatabaseManager;
import net.rafalohaki.veloauth.i18n.Messages;
import net.rafalohaki.veloauth.i18n.SimpleMessages;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public final class DatabaseErrorHandler {
    private static final Marker SECURITY_MARKER = MarkerFactory.getMarker("SECURITY");

    private DatabaseErrorHandler() {
    }

    public static boolean handleError(DatabaseManager.DbResult<?> result, Player player, String operation, Logger logger, Messages messages) {
        if (result.isDatabaseError()) {
            if (logger.isErrorEnabled()) {
                logger.error(SECURITY_MARKER, "[DATABASE ERROR] {} failed for {}: {}", operation, player.getUsername(), result.getErrorMessage());
            }
            SimpleMessages sm = new SimpleMessages(messages);
            player.sendMessage(sm.errorDatabase());
            return true;
        }
        return false;
    }

    public static boolean handleError(DatabaseManager.DbResult<?> result, CommandSource source, String identifier, String operation, Logger logger, Messages messages) {
        if (result.isDatabaseError()) {
            logger.error(SECURITY_MARKER, "[DATABASE ERROR] {} {}: {}", operation, identifier, result.getErrorMessage());
            source.sendMessage(ValidationUtils.createErrorComponent(messages.get("error.database.query", new Object[0])));
            return true;
        }
        return false;
    }

    public static boolean handleErrorWithKey(DatabaseManager.DbResult<?> result, Player player, String operation, Logger logger, Messages messages, String errorKey) {
        if (result.isDatabaseError()) {
            if (logger.isErrorEnabled()) {
                logger.error(SECURITY_MARKER, "[DATABASE ERROR] {} failed for {}: {}", operation, player.getUsername(), result.getErrorMessage());
            }
            player.sendMessage(ValidationUtils.createErrorComponent(messages.get(errorKey, new Object[0])));
            return true;
        }
        return false;
    }
}

