/*
 * Decompiled with CFR 0.152.
 */
package net.rafalohaki.veloauth.util;

import com.velocitypowered.api.event.connection.PreLoginEvent;
import com.velocitypowered.api.proxy.InboundConnection;
import com.velocitypowered.api.proxy.Player;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.LoggerFactory;

public final class PlayerAddressUtils {
    private PlayerAddressUtils() {
    }

    @Nonnull
    public static String getPlayerIp(@Nullable Player player) {
        if (player == null) {
            return "unknown";
        }
        InetSocketAddress address = player.getRemoteAddress();
        if (address == null) {
            LoggerFactory.getLogger(PlayerAddressUtils.class).warn("Player {} has null remote address", (Object)player.getUsername());
            return "unknown";
        }
        if (address instanceof InetSocketAddress) {
            InetSocketAddress inetAddress = address;
            String hostAddress = inetAddress.getAddress().getHostAddress();
            return hostAddress != null ? hostAddress : "unknown";
        }
        return "unknown";
    }

    @Nullable
    public static InetAddress getPlayerAddress(@Nullable Player player) {
        if (player == null) {
            return null;
        }
        InetSocketAddress address = player.getRemoteAddress();
        if (address == null) {
            LoggerFactory.getLogger(PlayerAddressUtils.class).warn("Player {} has null remote address", (Object)player.getUsername());
            return null;
        }
        if (address instanceof InetSocketAddress) {
            InetSocketAddress inetAddress = address;
            return inetAddress.getAddress();
        }
        return null;
    }

    @Nullable
    public static InetAddress getAddressFromPreLogin(@Nullable PreLoginEvent event) {
        if (event == null) {
            return null;
        }
        try {
            InboundConnection connection = event.getConnection();
            if (connection == null) {
                LoggerFactory.getLogger(PlayerAddressUtils.class).debug("PreLoginEvent has null connection");
                return null;
            }
            InetSocketAddress address = connection.getRemoteAddress();
            if (address == null) {
                LoggerFactory.getLogger(PlayerAddressUtils.class).warn("PreLoginEvent connection has null remote address for user: {}", (Object)event.getUsername());
                return null;
            }
            if (address instanceof InetSocketAddress) {
                InetSocketAddress inetAddress = address;
                return inetAddress.getAddress();
            }
        }
        catch (Exception e) {
            LoggerFactory.getLogger(PlayerAddressUtils.class).error("Error extracting address from PreLoginEvent", e);
        }
        return null;
    }

    public static boolean hasValidAddress(@Nullable Player player) {
        if (player == null) {
            return false;
        }
        InetSocketAddress address = player.getRemoteAddress();
        return address instanceof InetSocketAddress;
    }
}

