/*
 * Decompiled with CFR 0.152.
 */
package net.rafalohaki.veloauth.util;

import java.net.InetAddress;
import net.rafalohaki.veloauth.cache.AuthCache;
import net.rafalohaki.veloauth.command.IPRateLimiter;

public final class SecurityUtils {
    private SecurityUtils() {
    }

    public static void resetSecurityCounters(InetAddress address, AuthCache authCache, IPRateLimiter rateLimiter) {
        if (address != null) {
            authCache.resetLoginAttempts(address);
            rateLimiter.reset(address);
        }
    }

    public static boolean isBruteForceBlocked(InetAddress address, AuthCache authCache) {
        if (address == null) {
            return false;
        }
        return authCache.isBlocked(address);
    }

    public static boolean registerFailedLogin(InetAddress address, AuthCache authCache) {
        if (address == null) {
            return false;
        }
        return authCache.registerFailedLogin(address);
    }
}

