/*
 * Decompiled with CFR 0.152.
 */
package net.rafalohaki.veloauth.util;

import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class VirtualThreadExecutorProvider {
    private static final Logger logger = LoggerFactory.getLogger(VirtualThreadExecutorProvider.class);
    private static final ExecutorService VIRTUAL_EXECUTOR = Executors.newVirtualThreadPerTaskExecutor();
    private static final AtomicBoolean SHUTDOWN_INITIATED = new AtomicBoolean(false);

    private VirtualThreadExecutorProvider() {
    }

    public static ExecutorService getVirtualExecutor() {
        if (SHUTDOWN_INITIATED.get()) {
            throw new RejectedExecutionException("Executor is shutting down");
        }
        return VIRTUAL_EXECUTOR;
    }

    public static boolean isShutdown() {
        return SHUTDOWN_INITIATED.get();
    }

    public static void shutdown() {
        if (!SHUTDOWN_INITIATED.compareAndSet(false, true)) {
            logger.warn("Shutdown already initiated");
            return;
        }
        try {
            logger.info("Initiating graceful shutdown of Virtual Thread executor...");
            VIRTUAL_EXECUTOR.shutdown();
            if (!VIRTUAL_EXECUTOR.awaitTermination(10L, TimeUnit.SECONDS)) {
                logger.warn("Executor did not terminate within 10 seconds, forcing shutdown...");
                List<Runnable> droppedTasks = VIRTUAL_EXECUTOR.shutdownNow();
                logger.warn("Forced shutdown - {} tasks were dropped", (Object)droppedTasks.size());
                if (!VIRTUAL_EXECUTOR.awaitTermination(5L, TimeUnit.SECONDS)) {
                    logger.error("Executor did not terminate after forced shutdown");
                }
            } else {
                logger.info("Virtual Thread executor shutdown completed successfully");
            }
        }
        catch (InterruptedException e) {
            logger.error("Shutdown interrupted", e);
            VIRTUAL_EXECUTOR.shutdownNow();
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            logger.error("Error during Virtual Thread executor shutdown", e);
        }
    }
}

