package games.enchanted.eg_stop_unloading_my_shaders.common;

import games.enchanted.eg_stop_unloading_my_shaders.common.config.ConfigManager;
import games.enchanted.eg_stop_unloading_my_shaders.common.screen.CustomOverlayManager;
import games.enchanted.eg_stop_unloading_my_shaders.common.translations.Messages;
import org.jetbrains.annotations.Nullable;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3902;
import net.minecraft.class_4014;
import net.minecraft.class_8012;

public abstract class ShaderReloadManager {
    private static boolean isHotReloading = false;
    private static final List<ShaderLogMessage> knownErrorsThisReload = new ArrayList<>();

    public static void triggerReload() {
        isHotReloading = true;
        CustomOverlayManager.SHADER_MESSAGE_OVERLAY.clear();
        showReloadingShadersMessage();
        setCollapsedMessages();
        class_310 minecraft = class_310.method_1551();
        class_4014.method_40087(
            minecraft.method_1478(),
            List.of(minecraft.method_62887()),
            class_156.method_18349(),
            minecraft,
            CompletableFuture.completedFuture(class_3902.field_17274),
            false
        ).method_18364()
        .whenComplete(((result, exception) -> {
            isHotReloading = false;
            clearKnownErrors();
            if(exception == null) return;
            Logging.error("Error while reloading shaders: {}", exception);
        }));
    }

    public static void showReloadingShadersMessage() {
        showMessage(Messages.getReloadingShadersMessage(), 200);
    }

    protected static void setCollapsedMessages() {
        CustomOverlayManager.SHADER_MESSAGE_OVERLAY.setMessagesToShowWhenCollapsed(List.of(
            Messages.appendMessagePrefix(Messages.MessagePrefix.SUMR, class_2561.method_48321("info.eg_stop_unloading_my_shaders.shader_errors", "_There are some shader errors!")),
            Messages.appendMessagePrefix(Messages.MessagePrefix.NONE, class_2561.method_48321("info.eg_stop_unloading_my_shaders.click_to_show_errors", "_Click here to show or F3 + R to reload shaders").method_54663(class_8012.field_45073))
        ));
    }

    public static void showShaderErrorMessage(class_2561 shortMessage, @Nullable class_2561 longMessage) {
        ShaderLogMessage shaderLogMessage = new ShaderLogMessage(shortMessage.getString(), longMessage == null ? null : longMessage.getString());
        if(knownErrorsThisReload.contains(shaderLogMessage)) {
            return;
        } else {
            knownErrorsThisReload.add(shaderLogMessage);
        }
        showErrorMessage(shortMessage);
        if(longMessage != null) {
            showContinuationErrorMessage(longMessage);
        }
    }

    public static void showErrorMessage(class_2561 message) {
        showMessage(Messages.appendMessagePrefix(Messages.MessagePrefix.ERROR, message));
    }

    public static void showContinuationErrorMessage(class_2561 message) {
        showMessage(Messages.appendMessagePrefix(Messages.MessagePrefix.ERROR_CONTINUATION, Messages.colourMessageGrey(message)));
    }

    public static void showMessage(class_2561 message) {
        showMessage(message, -1);
    }

    /**
     * Shows a message to the shader message overlay and/or Minecraft chat.
     *
     * @param message      the message
     * @param ticksVisible clears message after x ticks, if set will add this message as the first one.
     *                     Set to -1 to add a message normally. Only applies to the shader message
     *                     overlay
     */
    public static void showMessage(class_2561 message, int ticksVisible) {
        class_310.method_1551().execute(() -> {
            if(ConfigManager.loggingMode.showInChat()) {
                class_310.method_1551().field_1705.method_1743().method_1812(message);
            }
            if(!ConfigManager.loggingMode.showInBox()) return;
            if(ticksVisible > 0) {
                CustomOverlayManager.SHADER_MESSAGE_OVERLAY.addMessage(message, ticksVisible);
                return;
            }
            CustomOverlayManager.SHADER_MESSAGE_OVERLAY.addMessage(message);
            CustomOverlayManager.SHADER_MESSAGE_OVERLAY.setCollapseAfterTicks(isHotReloading ? 2400 : 1200);
        });
    }

    private static void clearKnownErrors() {
        knownErrorsThisReload.clear();
    }

    public static void finishedVanillaReload() {
        if(isHotReloading) return;
        clearKnownErrors();
        setCollapsedMessages();
    }

    public static void startedVanillaReload() {
        if(!class_310.method_1551().method_53466()) return;
        if(isHotReloading) return;
        CustomOverlayManager.SHADER_MESSAGE_OVERLAY.clear();
    }

    public record ShaderLogMessage(String shortMessage, String longMessage) {}
}
