package games.enchanted.eg_stop_unloading_my_shaders.common.mixin.shader;

import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import games.enchanted.eg_stop_unloading_my_shaders.common.Logging;
import net.minecraft.class_151;
import net.minecraft.class_2960;
import net.minecraft.class_4239;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

// targets the inner GlslPreprocessor class in createPreprocessor
@Mixin(targets = "net.minecraft.client.renderer.ShaderManager$1")
public class ShaderManagerPreprocessorMixin {
    @Shadow @Final class_2960 val$parentLocation;

    @WrapMethod(
        method = "applyImport"
    )
    public String eg_sumr$catchImportErrors(boolean useFullPath, String directory, Operation<String> original) {
        class_2960 absoluteShaderLocation;
        if (useFullPath) {
            absoluteShaderLocation = val$parentLocation.method_45134(parent -> class_4239.method_34676(parent + directory));
        } else {
            try {
                absoluteShaderLocation = class_2960.method_60654(directory).method_45138("shaders/include/");
            } catch (class_151 var8) {
                absoluteShaderLocation = null;
            }
        }

        String originalImport;
        String shaderLocation = absoluteShaderLocation == null ? directory : absoluteShaderLocation.method_12836() + "/" + absoluteShaderLocation.method_12832();
        try {
            originalImport = original.call(useFullPath, directory);
        } catch (NullPointerException e) {
            Logging.error("Invalid glsl import directive {}: Could not find file to import", shaderLocation);
            return "#error Invalid import directive: file [%s] was not found".formatted(shaderLocation);
        } catch (Exception e) {
            Logging.error("Invalid glsl import directive {}: Unknown error occurred\n{}", shaderLocation, e.getMessage());
            return "#error Invalid import directive [%s], unknown error occurred: %s".formatted(shaderLocation, e.getMessage());
        }
        return originalImport;
    }
}
