/*
 * Decompiled with CFR 0.152.
 */
package games.enchanted.eg_stop_unloading_my_shaders.common.config;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JavaOps;
import games.enchanted.eg_stop_unloading_my_shaders.common.Logging;
import games.enchanted.eg_stop_unloading_my_shaders.common.ModConstants;
import games.enchanted.eg_stop_unloading_my_shaders.common.ShaderReloadManager;
import games.enchanted.eg_stop_unloading_my_shaders.common.config.ErrorLoggingMode;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Properties;
import net.minecraft.network.chat.Component;
import net.minecraft.util.StringRepresentable;

public class ConfigManager {
    private static final String LOGGING_MODE_KEY = "logging_mode";
    public static ErrorLoggingMode loggingMode = ErrorLoggingMode.BOX;
    private static final String LINKER_LOGS_KEY = "disable_linker_logs";
    public static boolean disableLinkerLogs = false;
    private static final String CONFIG_FILE_NAME = "eg_stop_unloading_my_shaders.properties";

    private static Path getConfigFilePath() {
        return ModConstants.getConfigPath().resolve(CONFIG_FILE_NAME);
    }

    public static void loadFromFile() {
        String disableLinkerLogs;
        Properties modProperties;
        block6: {
            modProperties = new Properties();
            try {
                modProperties.load(new FileInputStream(ConfigManager.getConfigFilePath().toFile()));
            }
            catch (IOException e) {
                boolean success = ConfigManager.saveFile();
                if (success) break block6;
                ShaderReloadManager.showErrorMessage((Component)Component.translatableWithFallback((String)"config.eg_stop_unloading_my_shaders.couldnt_open_file", (String)"_Couldn't open config file: %s", (Object[])new Object[]{CONFIG_FILE_NAME}));
                ShaderReloadManager.showContinuationErrorMessage((Component)Component.literal((String)e.getMessage()));
                Logging.error(e.getMessage(), new Object[0]);
                Logging.error(Arrays.toString(e.getStackTrace()), new Object[0]);
            }
        }
        String loggingMode = modProperties.getProperty(LOGGING_MODE_KEY);
        if (loggingMode != null) {
            DataResult result = StringRepresentable.fromValues(ErrorLoggingMode::values).decode((DynamicOps)JavaOps.INSTANCE, (Object)loggingMode);
            if (result.error().isPresent()) {
                ShaderReloadManager.showErrorMessage((Component)Component.translatableWithFallback((String)"config.eg_stop_unloading_my_shaders.couldnt_parse_file_prop", (String)"_Couldn't parse config property: %s", (Object[])new Object[]{LOGGING_MODE_KEY}));
                ShaderReloadManager.showContinuationErrorMessage((Component)Component.literal((String)((DataResult.Error)result.error().get()).message()));
                Logging.error(((DataResult.Error)result.error().get()).message(), new Object[0]);
            } else {
                ConfigManager.loggingMode = (ErrorLoggingMode)((Object)((Pair)result.getOrThrow()).getFirst());
            }
        }
        if ((disableLinkerLogs = modProperties.getProperty(LINKER_LOGS_KEY)) != null) {
            ConfigManager.disableLinkerLogs = Boolean.parseBoolean(disableLinkerLogs);
        }
        ConfigManager.saveFile();
    }

    public static boolean saveFile() {
        Properties modProperties = new Properties();
        modProperties.setProperty(LOGGING_MODE_KEY, loggingMode.getSerializedName());
        modProperties.setProperty(LINKER_LOGS_KEY, disableLinkerLogs ? "true" : "false");
        try {
            modProperties.store(new FileWriter(ConfigManager.getConfigFilePath().toFile()), "Stop Unloading My Resourcepacks Config");
        }
        catch (IOException e) {
            ShaderReloadManager.showErrorMessage((Component)Component.translatableWithFallback((String)"config.eg_stop_unloading_my_shaders.couldnt_save_file", (String)"_Couldn't save config file: %s", (Object[])new Object[]{CONFIG_FILE_NAME}));
            ShaderReloadManager.showContinuationErrorMessage((Component)Component.literal((String)e.getMessage()));
            Logging.error(e.getMessage(), new Object[0]);
            Logging.error(Arrays.toString(e.getStackTrace()), new Object[0]);
            return false;
        }
        return true;
    }

    public static void logCurrentConfig() {
        StringBuilder builder = new StringBuilder("Current Config Values:");
        builder.append("\n").append(LOGGING_MODE_KEY).append(": ").append(loggingMode.getSerializedName());
        builder.append("\n").append(LINKER_LOGS_KEY).append(": ").append(disableLinkerLogs);
        Logging.info(builder.toString(), new Object[0]);
    }

    static {
        ConfigManager.loadFromFile();
        ConfigManager.logCurrentConfig();
    }
}

