/*
 * Decompiled with CFR 0.152.
 */
package games.enchanted.eg_stop_unloading_my_shaders.common.config;

import games.enchanted.eg_stop_unloading_my_shaders.common.config.ConfigManager;
import games.enchanted.eg_stop_unloading_my_shaders.common.config.ErrorLoggingMode;
import games.enchanted.eg_stop_unloading_my_shaders.common.translations.Messages;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.HeaderAndFooterLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;

public class ConfigScreen
extends Screen {
    private static final Component TITLE = Component.translatableWithFallback((String)"gui.eg_stop_unloading_my_shaders.config.title", (String)"Stop Unloading My Resourcepacks Config").withStyle(Style.EMPTY.withBold(Boolean.valueOf(true)));
    private static final String LOG_MODE_KEY = "gui.eg_stop_unloading_my_shaders.button.log_mode";
    private static final String LOG_MODE_FALLBACK = "_Log messages to: %s";
    private static final String DISABLE_LINKER_LOGS_KEY = "gui.eg_stop_unloading_my_shaders.button.disable_linker_logs";
    private static final String DISABLE_LINKER_LOGS_FALBACK = "_Hide linker logs: %s";
    private final HeaderAndFooterLayout headerAndFooterLayout = new HeaderAndFooterLayout((Screen)this);
    private final LinearLayout contentsFlow = LinearLayout.vertical().spacing(8);
    private final Screen parent;

    protected ConfigScreen(Screen parent) {
        super(TITLE);
        this.parent = parent;
    }

    protected void init() {
        super.init();
        this.headerAndFooterLayout.addTitleHeader(TITLE, this.font);
        this.headerAndFooterLayout.addToFooter((LayoutElement)Button.builder((Component)CommonComponents.GUI_DONE, widget -> this.onClose()).width(200).build());
        this.contentsFlow.setY(64);
        this.addConfigOptions();
        this.headerAndFooterLayout.visitWidgets(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
        this.contentsFlow.visitWidgets(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
        this.repositionElements();
    }

    protected void addConfigOptions() {
        this.contentsFlow.addChild((LayoutElement)Button.builder((Component)Messages.translateWithFallback(LOG_MODE_KEY, ConfigManager.loggingMode.getTranslated(), LOG_MODE_FALLBACK), widget -> {
            ConfigManager.loggingMode = ErrorLoggingMode.getNext(ConfigManager.loggingMode);
            widget.setMessage(Messages.translateWithFallback(LOG_MODE_KEY, ConfigManager.loggingMode.getTranslated(), LOG_MODE_FALLBACK));
            ConfigManager.saveFile();
        }).tooltip(Tooltip.create((Component)Component.translatable((String)"gui.eg_stop_unloading_my_shaders.button.log_mode.tooltip"))).bounds(this.width / 2 - 100, this.height / 2 - 20 - 24, 200, 20).build());
        this.contentsFlow.addChild((LayoutElement)Button.builder((Component)Messages.translateWithFallback(DISABLE_LINKER_LOGS_KEY, ConfigScreen.getToggledComponent(CommonComponents.OPTION_ON, CommonComponents.OPTION_OFF, ConfigManager.disableLinkerLogs), DISABLE_LINKER_LOGS_FALBACK), widget -> {
            ConfigManager.disableLinkerLogs = !ConfigManager.disableLinkerLogs;
            widget.setMessage(Messages.translateWithFallback(DISABLE_LINKER_LOGS_KEY, ConfigScreen.getToggledComponent(CommonComponents.OPTION_ON, CommonComponents.OPTION_OFF, ConfigManager.disableLinkerLogs), DISABLE_LINKER_LOGS_FALBACK));
            ConfigManager.saveFile();
        }).tooltip(Tooltip.create((Component)Component.translatable((String)"gui.eg_stop_unloading_my_shaders.button.disable_linker_logs.tooltip"))).bounds(this.width / 2 - 100, this.height / 2 - 20 - 23, 200, 20).build());
        this.repositionElements();
    }

    public static Component getToggledComponent(Component first, Component second, boolean toggle) {
        return toggle ? first : second;
    }

    protected void repositionElements() {
        this.headerAndFooterLayout.arrangeElements();
        this.contentsFlow.setX(this.width / 2 - this.contentsFlow.getWidth() / 2);
        this.contentsFlow.arrangeElements();
    }

    public void onClose() {
        ConfigManager.logCurrentConfig();
        assert (this.minecraft != null);
        this.minecraft.setScreen(this.parent);
    }

    public static Screen createConfigScreen(Screen parent) {
        return new ConfigScreen(parent);
    }
}

