/*
 * Decompiled with CFR 0.152.
 */
package games.enchanted.eg_stop_unloading_my_shaders.common.config;

import net.minecraft.network.chat.Component;
import net.minecraft.util.StringRepresentable;
import org.jetbrains.annotations.NotNull;

public enum ErrorLoggingMode implements StringRepresentable
{
    BOX("box", true, false),
    CHAT("chat", false, true),
    BOTH("both", true, true);

    private final String name;
    private final boolean showInBox;
    private final boolean showInChat;
    private static final ErrorLoggingMode[] values;

    private ErrorLoggingMode(String name, boolean showInBox, boolean showInChat) {
        this.name = name;
        this.showInBox = showInBox;
        this.showInChat = showInChat;
    }

    @NotNull
    public String getSerializedName() {
        return this.name;
    }

    public Component getTranslated() {
        return Component.translatableWithFallback((String)("config.eg_stop_unloading_my_shaders.log_mode." + this.name), (String)this.name);
    }

    public boolean showInChat() {
        return this.showInChat;
    }

    public boolean showInBox() {
        return this.showInBox;
    }

    public static ErrorLoggingMode getNext(ErrorLoggingMode mode) {
        return values[(mode.ordinal() + 1) % values.length];
    }

    static {
        values = ErrorLoggingMode.values();
    }
}

