/*
 * Decompiled with CFR 0.152.
 */
package games.enchanted.eg_stop_unloading_my_shaders.common.screen;

import games.enchanted.eg_stop_unloading_my_shaders.common.screen.CustomOverlay;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ComponentRenderUtils;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;

public class ShaderMessageOverlay
extends CustomOverlay {
    private static final int PADDING_BLOCK = 6;
    private static final int PADDING_INLINE = 4;
    private static final ResourceLocation LINE_BACKGROUND_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"eg_stop_unloading_my_shaders", (String)"error_box/line_background");
    private static final ResourceLocation LINE_BACKGROUND_HOVER_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"eg_stop_unloading_my_shaders", (String)"error_box/line_background_hover");
    private static final int ARROW_SIZE = 6;
    private static final ResourceLocation ARROW_DOWN_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"eg_stop_unloading_my_shaders", (String)"error_box/arrow_down");
    private static final ResourceLocation ARROW_UP_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"eg_stop_unloading_my_shaders", (String)"error_box/arrow_up");
    private boolean isClearing = false;
    private int removePinnedAtAge = -1;
    private int removeAllAtAge = -1;
    private final ArrayList<Component> rawMessages = new ArrayList();
    private final ArrayList<FormattedCharSequence> splitMessageLines = new ArrayList();
    private int currentScrollIndex = 0;
    private final float scale = 1.0f;
    private final int lineWidth = 320;
    private final int lineHeight = 9;
    private final int visibleLines = 9;
    private int age = 0;

    public void addMessage(Component message) {
        this.addPinnedMessage(message, -1);
    }

    public void addPinnedMessage(Component message, int ticksVisible) {
        List wrapped = ComponentRenderUtils.wrapComponents((FormattedText)message, (int)320, (Font)Minecraft.getInstance().font);
        if (ticksVisible > -1) {
            this.splitMessageLines.addAll(0, wrapped);
            this.rawMessages.addFirst(message);
            this.removePinnedAtAge = this.age + ticksVisible;
        } else {
            this.splitMessageLines.addAll(wrapped);
            this.rawMessages.add(message);
        }
        this.scrollByLines(0);
    }

    private void scrollByLines(int lines) {
        this.currentScrollIndex += lines;
        int totalLines = this.splitMessageLines.size();
        int maxScroll = totalLines - 9;
        if (this.currentScrollIndex > maxScroll) {
            this.currentScrollIndex = maxScroll;
        }
        if (this.currentScrollIndex <= 0) {
            this.currentScrollIndex = 0;
        }
    }

    @Override
    public void tick() {
        super.tick();
        ++this.age;
        if (this.removePinnedAtAge > -1 && this.age > this.removePinnedAtAge && !this.rawMessages.isEmpty() && !this.isClearing) {
            this.rawMessages.removeFirst();
            this.resplitMessages();
            this.removePinnedAtAge = -1;
        }
        if (this.removeAllAtAge > -1 && this.age > this.removeAllAtAge) {
            this.clear();
            this.removeAllAtAge = -1;
        }
    }

    private void resplitMessages() {
        this.splitMessageLines.clear();
        for (Component message : this.rawMessages) {
            List wrapped = ComponentRenderUtils.wrapComponents((FormattedText)message, (int)320, (Font)Minecraft.getInstance().font);
            this.splitMessageLines.addAll(wrapped);
        }
    }

    public void clear() {
        this.isClearing = true;
        this.splitMessageLines.clear();
        this.rawMessages.clear();
        this.currentScrollIndex = 0;
        this.isClearing = false;
    }

    public void setRemoveAllAfterTicks(int ticks) {
        int newRemoveAtAge = this.age + ticks;
        if (newRemoveAtAge > this.removeAllAtAge) {
            this.removeAllAtAge = newRemoveAtAge;
        }
    }

    private boolean isHoveringScrollBox(double mouseX, double mouseY) {
        if (mouseX > (double)(this.lineWidth + 8)) {
            return false;
        }
        Objects.requireNonNull(this);
        Objects.requireNonNull(this);
        return !(mouseY > (double)(9 * Math.min(9, this.splitMessageLines.size()) + 12));
    }

    @Override
    public boolean onScroll(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (this.splitMessageLines.isEmpty()) {
            return false;
        }
        if (!this.isHoveringScrollBox(mouseX, mouseY)) {
            return false;
        }
        this.scrollByLines((int)Math.clamp(scrollY * -1.0, -1.0, 1.0));
        return true;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        boolean isAtBottom;
        if (this.splitMessageLines.isEmpty()) {
            return;
        }
        int linesToRender = Math.min(this.splitMessageLines.size() - this.currentScrollIndex, 9);
        int width = 328;
        guiGraphics.pose().pushMatrix();
        guiGraphics.pose().scale(this.scale);
        for (int i = 0; i < linesToRender; ++i) {
            boolean isLastVisible = i == linesToRender - 1;
            boolean isFirstVisible = i == 0;
            int x = 4;
            int y = 6 + i * 9;
            int height = isLastVisible ? 15 : 9;
            guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, this.isHoveringScrollBox(mouseX, mouseY) ? LINE_BACKGROUND_HOVER_LOCATION : LINE_BACKGROUND_LOCATION, 0, isFirstVisible ? 0 : y, width, isFirstVisible ? y + height : height);
            guiGraphics.drawString(Minecraft.getInstance().font, this.splitMessageLines.get(i + this.currentScrollIndex), x, y, -1);
        }
        boolean isAtTop = this.currentScrollIndex == 0;
        int n = this.splitMessageLines.size();
        Objects.requireNonNull(this);
        boolean bl = isAtBottom = this.currentScrollIndex >= n - 9;
        if (!isAtTop) {
            guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, ARROW_UP_LOCATION, width / 2 - 3, 0, 6, 6);
        }
        if (!isAtBottom) {
            guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, ARROW_DOWN_LOCATION, width / 2 - 3, linesToRender * 9 + 6, 6, 6);
        }
        guiGraphics.pose().popMatrix();
    }
}

