/*
 * Decompiled with CFR 0.152.
 */
package games.enchanted.eg_stop_unloading_my_shaders.common.translations;

import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;

public class Messages {
    public static Component appendMessagePrefix(MessagePrefix messagePrefix, Component message) {
        return Component.empty().append(messagePrefix.getAsComponent()).append(CommonComponents.SPACE).append(message);
    }

    public static Component translateWithFallback(String key, Component value, String fallback) {
        return Component.translatableWithFallback((String)key, (String)fallback, (Object[])new Object[]{value.getString()});
    }

    public static Component getReloadingShadersMessage() {
        return Messages.appendMessagePrefix(MessagePrefix.INFO, (Component)Component.translatableWithFallback((String)"debug.eg_stop_unloading_my_shaders.reloading_shaders", (String)"_Reloading shaders"));
    }

    public static Component getFailedToLoadPostChainMessage(String location) {
        return Component.translatableWithFallback((String)"debug.eg_stop_unloading_my_shaders.post_chain_load_error", (String)"_Failed to load post_effect %s:", (Object[])new Object[]{location});
    }

    public static Component getCouldntFindPostChainSource(String location) {
        return Component.translatableWithFallback((String)"debug.eg_stop_unloading_my_shaders.no_post_chain_source_error", (String)"_Couldn't find config .json for post_effect: %s", (Object[])new Object[]{location});
    }

    public static Component getFailedToLinkMessage(String pipelineLocation) {
        return Component.translatableWithFallback((String)"debug.eg_stop_unloading_my_shaders.linkage_error", (String)"_Failed to link programs for pipeline %s:", (Object[])new Object[]{pipelineLocation});
    }

    public static Component getCouldntFindSourceMessage(String shaderType, String shaderLocation) {
        return Component.translatableWithFallback((String)"debug.eg_stop_unloading_my_shaders.no_source_error", (String)"_Couldn't find source for %s shader: %s", (Object[])new Object[]{shaderType, shaderLocation});
    }

    public static Component getCouldntCompileShaderMessage(String shaderType, String shaderLocation) {
        return Component.translatableWithFallback((String)"debug.eg_stop_unloading_my_shaders.compilation_error", (String)"_Couldn't compile %s shader: %s", (Object[])new Object[]{shaderType, shaderLocation});
    }

    public static Component getCouldntGetFullErrorMessage() {
        return Component.translatableWithFallback((String)"debug.eg_stop_unloading_my_shaders.no_full_error", (String)"_Couldn't get full error message");
    }

    public static Component colourMessageGrey(Component message) {
        return message.copy().withColor(-6250336);
    }

    public static enum MessagePrefix {
        INFO("prefix.eg_stop_unloading_my_shaders.info", "_[SUMR Info]:", Style.EMPTY.withBold(Boolean.valueOf(true)).withColor(ChatFormatting.YELLOW)),
        ERROR("prefix.eg_stop_unloading_my_shaders.error", "_[SUMR Error]:", Style.EMPTY.withBold(Boolean.valueOf(true)).withColor(ChatFormatting.RED)),
        ERROR_CONTINUATION("prefix.eg_stop_unloading_my_shaders.error_continuation", "_\u2514", Style.EMPTY.withBold(Boolean.valueOf(true)).withColor(ChatFormatting.RED));

        private final String translationKey;
        private final String fallback;
        private final Style style;

        private MessagePrefix(String translationKey, String fallback, Style style) {
            this.translationKey = translationKey;
            this.fallback = fallback;
            this.style = style;
        }

        Component getAsComponent() {
            return Component.translatableWithFallback((String)this.translationKey, (String)this.fallback).withStyle(this.style);
        }
    }
}

