/*
 * Decompiled with CFR 0.152.
 */
package games.enchanted.eg_stop_unloading_my_shaders.common.screen;

import games.enchanted.eg_stop_unloading_my_shaders.common.screen.CustomOverlay;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_10799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_341;
import net.minecraft.class_5348;
import net.minecraft.class_5481;

public class ShaderMessageOverlay
extends CustomOverlay {
    private static final int PADDING_BLOCK = 6;
    private static final int PADDING_INLINE = 4;
    private static final class_2960 LINE_BACKGROUND_LOCATION = class_2960.method_60655((String)"eg_stop_unloading_my_shaders", (String)"error_box/line_background");
    private static final class_2960 LINE_BACKGROUND_HOVER_LOCATION = class_2960.method_60655((String)"eg_stop_unloading_my_shaders", (String)"error_box/line_background_hover");
    private static final int ARROW_SIZE = 6;
    private static final class_2960 ARROW_DOWN_LOCATION = class_2960.method_60655((String)"eg_stop_unloading_my_shaders", (String)"error_box/arrow_down");
    private static final class_2960 ARROW_UP_LOCATION = class_2960.method_60655((String)"eg_stop_unloading_my_shaders", (String)"error_box/arrow_up");
    private boolean isClearing = false;
    private int removePinnedAtAge = -1;
    private int removeAllAtAge = -1;
    private final ArrayList<class_2561> rawMessages = new ArrayList();
    private final ArrayList<class_5481> splitMessageLines = new ArrayList();
    private int currentScrollIndex = 0;
    private final float scale = 1.0f;
    private final int lineWidth = 320;
    private final int lineHeight = 9;
    private final int visibleLines = 9;
    private int age = 0;

    public void addMessage(class_2561 message) {
        this.addPinnedMessage(message, -1);
    }

    public void addPinnedMessage(class_2561 message, int ticksVisible) {
        List wrapped = class_341.method_1850((class_5348)message, (int)320, (class_327)class_310.method_1551().field_1772);
        if (ticksVisible > -1) {
            this.splitMessageLines.addAll(0, wrapped);
            this.rawMessages.addFirst(message);
            this.removePinnedAtAge = this.age + ticksVisible;
        } else {
            this.splitMessageLines.addAll(wrapped);
            this.rawMessages.add(message);
        }
        this.scrollByLines(0);
    }

    private void scrollByLines(int lines) {
        this.currentScrollIndex += lines;
        int totalLines = this.splitMessageLines.size();
        int maxScroll = totalLines - 9;
        if (this.currentScrollIndex > maxScroll) {
            this.currentScrollIndex = maxScroll;
        }
        if (this.currentScrollIndex <= 0) {
            this.currentScrollIndex = 0;
        }
    }

    @Override
    public void method_4622() {
        super.method_4622();
        ++this.age;
        if (this.removePinnedAtAge > -1 && this.age > this.removePinnedAtAge && !this.rawMessages.isEmpty() && !this.isClearing) {
            this.rawMessages.removeFirst();
            this.resplitMessages();
            this.removePinnedAtAge = -1;
        }
        if (this.removeAllAtAge > -1 && this.age > this.removeAllAtAge) {
            this.clear();
            this.removeAllAtAge = -1;
        }
    }

    private void resplitMessages() {
        this.splitMessageLines.clear();
        for (class_2561 message : this.rawMessages) {
            List wrapped = class_341.method_1850((class_5348)message, (int)320, (class_327)class_310.method_1551().field_1772);
            this.splitMessageLines.addAll(wrapped);
        }
    }

    public void clear() {
        this.isClearing = true;
        this.splitMessageLines.clear();
        this.rawMessages.clear();
        this.currentScrollIndex = 0;
        this.isClearing = false;
    }

    public void setRemoveAllAfterTicks(int ticks) {
        int newRemoveAtAge = this.age + ticks;
        if (newRemoveAtAge > this.removeAllAtAge) {
            this.removeAllAtAge = newRemoveAtAge;
        }
    }

    private boolean isHoveringScrollBox(double mouseX, double mouseY) {
        if (mouseX > (double)(this.lineWidth + 8)) {
            return false;
        }
        Objects.requireNonNull(this);
        Objects.requireNonNull(this);
        return !(mouseY > (double)(9 * Math.min(9, this.splitMessageLines.size()) + 12));
    }

    @Override
    public boolean onScroll(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (this.splitMessageLines.isEmpty()) {
            return false;
        }
        if (!this.isHoveringScrollBox(mouseX, mouseY)) {
            return false;
        }
        this.scrollByLines((int)Math.clamp(scrollY * -1.0, -1.0, 1.0));
        return true;
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        boolean isAtBottom;
        if (this.splitMessageLines.isEmpty()) {
            return;
        }
        int linesToRender = Math.min(this.splitMessageLines.size() - this.currentScrollIndex, 9);
        int width = 328;
        guiGraphics.method_51448().pushMatrix();
        guiGraphics.method_51448().scale(this.scale);
        for (int i = 0; i < linesToRender; ++i) {
            boolean isLastVisible = i == linesToRender - 1;
            boolean isFirstVisible = i == 0;
            int x = 4;
            int y = 6 + i * 9;
            int height = isLastVisible ? 15 : 9;
            guiGraphics.method_52706(class_10799.field_56883, this.isHoveringScrollBox(mouseX, mouseY) ? LINE_BACKGROUND_HOVER_LOCATION : LINE_BACKGROUND_LOCATION, 0, isFirstVisible ? 0 : y, width, isFirstVisible ? y + height : height);
            guiGraphics.method_35720(class_310.method_1551().field_1772, this.splitMessageLines.get(i + this.currentScrollIndex), x, y, -1);
        }
        boolean isAtTop = this.currentScrollIndex == 0;
        int n = this.splitMessageLines.size();
        Objects.requireNonNull(this);
        boolean bl = isAtBottom = this.currentScrollIndex >= n - 9;
        if (!isAtTop) {
            guiGraphics.method_52706(class_10799.field_56883, ARROW_UP_LOCATION, width / 2 - 3, 0, 6, 6);
        }
        if (!isAtBottom) {
            guiGraphics.method_52706(class_10799.field_56883, ARROW_DOWN_LOCATION, width / 2 - 3, linesToRender * 9 + 6, 6, 6);
        }
        guiGraphics.method_51448().popMatrix();
    }
}

