package games.enchanted.eg_stop_unloading_my_shaders.common.mixin.shader;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import games.enchanted.eg_stop_unloading_my_shaders.common.Logging;
import games.enchanted.eg_stop_unloading_my_shaders.common.ShaderReloadManager;
import games.enchanted.eg_stop_unloading_my_shaders.common.translations.Messages;
import games.enchanted.eg_stop_unloading_my_shaders.common.util.PostChainUtil;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

import java.util.Map;
import java.util.Set;
import net.minecraft.class_1060;
import net.minecraft.class_11278;
import net.minecraft.class_2561;
import net.minecraft.class_279;
import net.minecraft.class_2960;
import net.minecraft.class_9962;

@Mixin(targets = "net/minecraft/client/renderer/ShaderManager$CompilationCache")
public class CompilationCacheMixin {
    @WrapOperation(
        at = @At(value = "INVOKE", target = "Lnet/minecraft/client/renderer/PostChain;load(Lnet/minecraft/client/renderer/PostChainConfig;Lnet/minecraft/client/renderer/texture/TextureManager;Ljava/util/Set;Lnet/minecraft/resources/ResourceLocation;Lnet/minecraft/client/renderer/CachedOrthoProjectionMatrixBuffer;)Lnet/minecraft/client/renderer/PostChain;"),
        method = "loadPostChain"
    )
    private class_279 eg_sumr$loadDummyPostChainIfError(class_9962 config, class_1060 textureManager, Set<class_2960> externalTargets, class_2960 name, class_11278 projectionMatrixBuffer, Operation<class_279> original) {
        class_279 originalChain;
        try {
            originalChain = original.call(config, textureManager, externalTargets, name, projectionMatrixBuffer);
        } catch (Exception e) {
            ShaderReloadManager.showErrorMessage(Messages.getFailedToLoadPostChainMessage(name.toString()));
            ShaderReloadManager.showContinuationErrorMessage(class_2561.method_43470(e.getMessage()));
            Logging.error("Failed to load post chain {}:\n{}", name, e);
            return original.call(PostChainUtil.createDummyPostChainConfig(), textureManager, externalTargets, name, projectionMatrixBuffer);
        }
        return originalChain;
    }
    
    @WrapOperation(
        at = @At(value = "INVOKE", target = "Ljava/util/Map;get(Ljava/lang/Object;)Ljava/lang/Object;"),
        method = "loadPostChain"
    )
    private <V> V eg_sumr$loadDummyPostChainIfNoConfig(Map<class_2960, class_279> instance, Object key, Operation<V> original) {
        V originalConfig = original.call(instance, key);
        if(originalConfig == null) {
            ShaderReloadManager.showErrorMessage(Messages.getCouldntFindPostChainSource(key.toString()));
            //noinspection unchecked
            return (V) PostChainUtil.createDummyPostChainConfig();
        }
        return originalConfig;
    }
}
