package games.enchanted.eg_stop_unloading_my_shaders.common.mixin.shader;

import com.google.common.collect.ImmutableMap;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import games.enchanted.eg_stop_unloading_my_shaders.common.ShaderReloadManager;
import games.enchanted.eg_stop_unloading_my_shaders.common.translations.Messages;
import games.enchanted.eg_stop_unloading_my_shaders.common.util.PostChainUtil;
import net.minecraft.class_10151;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_9962;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_10151.class)
public class ShaderManagerMixin {
    @Inject(
        at = @At("HEAD"),
        method = "prepare(Lnet/minecraft/server/packs/resources/ResourceManager;Lnet/minecraft/util/profiling/ProfilerFiller;)Lnet/minecraft/client/renderer/ShaderManager$Configs;"
    )
    private void eg_sumr$onShaderManagerStart(class_3300 resourceManager, class_3695 profiler, CallbackInfoReturnable<class_10151.class_10153> cir) {
        ShaderReloadManager.startedVanillaReload();
    }

    @Inject(
        at = @At("RETURN"),
        method = "apply(Lnet/minecraft/client/renderer/ShaderManager$Configs;Lnet/minecraft/server/packs/resources/ResourceManager;Lnet/minecraft/util/profiling/ProfilerFiller;)V"
    )
    private void eg_sumr$onShaderManagerFinish(class_10151.class_10153 object, class_3300 resourceManager, class_3695 profiler, CallbackInfo ci) {
        ShaderReloadManager.finishedVanillaReload();
    }

    // ResourceLocation local is the result of POST_CHAIN_ID_CONVERTER.fileToId
    @WrapOperation(
        at = @At(value = "INVOKE", target = "Lorg/slf4j/Logger;error(Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;)V", remap = false),
        method = "loadPostChain(Lnet/minecraft/resources/ResourceLocation;Lnet/minecraft/server/packs/resources/Resource;Lcom/google/common/collect/ImmutableMap$Builder;)V"
    )
    private static void eg_sumr$addDummyPostChainConfigIfFailedToParse(Logger instance, String string, Object o, Object exception, Operation<Void> original, class_2960 rawLocation, class_3298 postChain, ImmutableMap.Builder<class_2960, class_9962> output, @Local(ordinal = 1) class_2960 name) {
        original.call(instance, string, o, exception);
        output.put(name, PostChainUtil.createDummyPostChainConfig());
        ShaderReloadManager.showErrorMessage(Messages.getFailedToLoadPostChainMessage(name.toString()));
        ShaderReloadManager.showContinuationErrorMessage(class_2561.method_43470(((Exception) exception).getMessage()));
    }
}
