/*
 * Decompiled with CFR 0.152.
 */
package games.enchanted.eg_stop_unloading_my_shaders.common;

import games.enchanted.eg_stop_unloading_my_shaders.common.Logging;
import games.enchanted.eg_stop_unloading_my_shaders.common.config.ConfigManager;
import games.enchanted.eg_stop_unloading_my_shaders.common.screen.CustomOverlayManager;
import games.enchanted.eg_stop_unloading_my_shaders.common.translations.Messages;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_3902;
import net.minecraft.class_4014;
import org.jetbrains.annotations.Nullable;

public abstract class ShaderReloadManager {
    private static boolean isHotReloading = false;
    private static boolean shouldLoadVanillaFallback = false;
    private static final List<ShaderLogMessage> knownErrorsThisReload = new ArrayList<ShaderLogMessage>();

    public static void triggerReload() {
        isHotReloading = true;
        CustomOverlayManager.SHADER_MESSAGE_OVERLAY.clear();
        ShaderReloadManager.showReloadingShadersMessage();
        class_310 minecraft = class_310.method_1551();
        class_4014.method_40087((class_3300)minecraft.method_1478(), List.of(minecraft.method_62887()), (Executor)class_156.method_18349(), (Executor)minecraft, CompletableFuture.completedFuture(class_3902.field_17274), (boolean)false).method_18364().whenComplete((result, exception) -> {
            isHotReloading = false;
            ShaderReloadManager.clearKnownErrors();
            if (exception == null) {
                return;
            }
            Logging.error("Error while reloading shaders: {}", exception);
        });
    }

    public static void showReloadingShadersMessage() {
        ShaderReloadManager.showMessage(Messages.getReloadingShadersMessage(), 200);
    }

    public static void showShaderErrorMessage(class_2561 shortMessage, @Nullable class_2561 longMessage) {
        ShaderLogMessage shaderLogMessage = new ShaderLogMessage(shortMessage.getString(), longMessage == null ? null : longMessage.getString());
        if (knownErrorsThisReload.contains(shaderLogMessage)) {
            return;
        }
        knownErrorsThisReload.add(shaderLogMessage);
        ShaderReloadManager.showErrorMessage(shortMessage);
        if (longMessage != null) {
            ShaderReloadManager.showContinuationErrorMessage(longMessage);
        }
    }

    public static void showErrorMessage(class_2561 message) {
        ShaderReloadManager.showMessage(Messages.appendMessagePrefix(Messages.MessagePrefix.ERROR, message));
    }

    public static void showContinuationErrorMessage(class_2561 message) {
        ShaderReloadManager.showMessage(Messages.appendMessagePrefix(Messages.MessagePrefix.ERROR_CONTINUATION, Messages.colourMessageGrey(message)));
    }

    public static void showMessage(class_2561 message) {
        ShaderReloadManager.showMessage(message, -1);
    }

    public static void showMessage(class_2561 message, int ticksVisible) {
        if (ConfigManager.loggingMode.showInChat()) {
            class_310.method_1551().field_1705.method_1743().method_1812(message);
        }
        if (!ConfigManager.loggingMode.showInBox()) {
            return;
        }
        if (ticksVisible > 0) {
            CustomOverlayManager.SHADER_MESSAGE_OVERLAY.addPinnedMessage(message, ticksVisible);
            return;
        }
        CustomOverlayManager.SHADER_MESSAGE_OVERLAY.addMessage(message);
        CustomOverlayManager.SHADER_MESSAGE_OVERLAY.setRemoveAllAfterTicks(isHotReloading ? 2400 : 1200);
    }

    private static void clearKnownErrors() {
        knownErrorsThisReload.clear();
    }

    public static boolean shouldLoadVanillaFallback() {
        return shouldLoadVanillaFallback;
    }

    public static void setShouldLoadVanillaFallback(boolean newValue) {
        shouldLoadVanillaFallback = newValue;
    }

    public static void finishedVanillaReload() {
        if (isHotReloading) {
            return;
        }
        ShaderReloadManager.clearKnownErrors();
    }

    public static void startedVanillaReload() {
        if (!class_310.method_1551().method_53466()) {
            return;
        }
        if (isHotReloading) {
            return;
        }
        CustomOverlayManager.SHADER_MESSAGE_OVERLAY.clear();
    }

    public record ShaderLogMessage(String shortMessage, String longMessage) {
    }
}

