package games.enchanted.eg_stop_unloading_my_shaders.common.config;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.JavaOps;
import games.enchanted.eg_stop_unloading_my_shaders.common.Logging;
import games.enchanted.eg_stop_unloading_my_shaders.common.ModConstants;
import games.enchanted.eg_stop_unloading_my_shaders.common.ShaderReloadManager;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Properties;
import net.minecraft.class_2561;
import net.minecraft.class_3542;

public class ConfigManager {
    private static final String LOGGING_MODE_KEY = "logging_mode";
    public static ErrorLoggingMode loggingMode = ErrorLoggingMode.BOX;

    private static final String LINKER_LOGS_KEY = "disable_linker_logs";
    public static boolean disableLinkerLogs = false;

    private static final String CONFIG_FILE_NAME = "eg_stop_unloading_my_shaders.properties";

    private static Path getConfigFilePath() {
        return ModConstants.getConfigPath().resolve(CONFIG_FILE_NAME);
    }

    public static void loadFromFile() {
        Properties modProperties = new Properties();
        try {
            modProperties.load(new FileInputStream(getConfigFilePath().toFile()));
        } catch (IOException e) {
            boolean success = saveFile();
            if(!success) {
                ShaderReloadManager.showErrorMessage(class_2561.method_48322("config.eg_stop_unloading_my_shaders.couldnt_open_file", "_Couldn't open config file: %s", CONFIG_FILE_NAME));
                ShaderReloadManager.showContinuationErrorMessage(class_2561.method_43470(e.getMessage()));
                Logging.error(e.getMessage());
                Logging.error(Arrays.toString(e.getStackTrace()));
            }
        }

        String loggingMode = modProperties.getProperty(LOGGING_MODE_KEY);
        if(loggingMode != null) {
            DataResult<Pair<ErrorLoggingMode, Object>> result = class_3542.method_53955(ErrorLoggingMode::values).decode(JavaOps.INSTANCE, loggingMode);
            if(result.error().isPresent()) {
                ShaderReloadManager.showErrorMessage(class_2561.method_48322("config.eg_stop_unloading_my_shaders.couldnt_parse_file_prop", "_Couldn't parse config property: %s", LOGGING_MODE_KEY));
                ShaderReloadManager.showContinuationErrorMessage(class_2561.method_43470(result.error().get().message()));
                Logging.error(result.error().get().message());
            } else {
                ConfigManager.loggingMode = result.getOrThrow().getFirst();
            }
        }


        String disableLinkerLogs = modProperties.getProperty(LINKER_LOGS_KEY);
        if(disableLinkerLogs != null) {
            ConfigManager.disableLinkerLogs = Boolean.parseBoolean(disableLinkerLogs);
        }
        saveFile();
    }

    public static boolean saveFile() {
        Properties modProperties = new Properties();

        modProperties.setProperty(LOGGING_MODE_KEY, loggingMode.method_15434());
        modProperties.setProperty(LINKER_LOGS_KEY, disableLinkerLogs ? "true" : "false");

        try {
            modProperties.store(new FileWriter(getConfigFilePath().toFile()), "Stop Unloading My Resourcepacks Config");
        } catch (IOException e) {
            ShaderReloadManager.showErrorMessage(class_2561.method_48322("config.eg_stop_unloading_my_shaders.couldnt_save_file", "_Couldn't save config file: %s", CONFIG_FILE_NAME));
            ShaderReloadManager.showContinuationErrorMessage(class_2561.method_43470(e.getMessage()));
            Logging.error(e.getMessage());
            Logging.error(Arrays.toString(e.getStackTrace()));
            return false;
        }

        return true;
    }

    public static void logCurrentConfig() {
        StringBuilder builder = new StringBuilder("Current Config Values:");
        builder.append("\n").append(LOGGING_MODE_KEY).append(": ").append(loggingMode.method_15434());
        builder.append("\n").append(LINKER_LOGS_KEY).append(": ").append(disableLinkerLogs);
        Logging.info(builder.toString());
    }

    static {
        loadFromFile();
        logCurrentConfig();
    }
}
