package games.enchanted.eg_stop_unloading_my_shaders.common.config;

import games.enchanted.eg_stop_unloading_my_shaders.common.translations.Messages;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_7919;
import net.minecraft.class_8132;
import net.minecraft.class_8667;

public class ConfigScreen extends class_437 {
    private static final class_2561 TITLE = class_2561.method_48321("gui.eg_stop_unloading_my_shaders.config.title", "Stop Unloading My Resourcepacks Config").method_27696(class_2583.field_24360.method_10982(true));
    private static final String LOG_MODE_KEY = "gui.eg_stop_unloading_my_shaders.button.log_mode";
    private static final String LOG_MODE_FALLBACK = "_Log messages to: %s";
    private static final String DISABLE_LINKER_LOGS_KEY = "gui.eg_stop_unloading_my_shaders.button.disable_linker_logs";
    private static final String DISABLE_LINKER_LOGS_FALBACK = "_Hide linker logs: %s";

    private final class_8132 headerAndFooterLayout = new class_8132(this);
    private final class_8667 contentsFlow = class_8667.method_52741().method_52735(8);
    private final class_437 parent;

    protected ConfigScreen(class_437 parent) {
        super(TITLE);
        this.parent = parent;
    }

    @Override
    protected void method_25426() {
        super.method_25426();

        this.headerAndFooterLayout.method_57726(TITLE, this.field_22793);
        this.headerAndFooterLayout.method_48996(class_4185.method_46430(class_5244.field_24334, (widget) -> this.method_25419()).method_46432(200).method_46431());
        this.contentsFlow.method_46419(64);

        addConfigOptions();

        this.headerAndFooterLayout.method_48206(this::method_37063);
        this.contentsFlow.method_48206(this::method_37063);

        this.method_48640();
    }

    protected void addConfigOptions() {
        contentsFlow.method_52736(
            class_4185.method_46430(Messages.translateWithFallback(LOG_MODE_KEY, ConfigManager.loggingMode.getTranslated(), LOG_MODE_FALLBACK), (widget) -> {
                    ConfigManager.loggingMode = ErrorLoggingMode.getNext(ConfigManager.loggingMode);
                    widget.method_25355(Messages.translateWithFallback(LOG_MODE_KEY, ConfigManager.loggingMode.getTranslated(), LOG_MODE_FALLBACK));
                    ConfigManager.saveFile();
                })
                .method_46436(class_7919.method_47407(class_2561.method_43471(LOG_MODE_KEY + ".tooltip")))
                .method_46434(this.field_22789 / 2 - (class_4185.field_49479 / 2), this.field_22790 / 2 - 20 - (class_4185.field_39501 + 4), class_4185.field_49479, class_4185.field_39501)
                .method_46431()
        );

        contentsFlow.method_52736(
            class_4185.method_46430(Messages.translateWithFallback(DISABLE_LINKER_LOGS_KEY, getToggledComponent(class_5244.field_24332, class_5244.field_24333, ConfigManager.disableLinkerLogs), DISABLE_LINKER_LOGS_FALBACK), (widget) -> {
                    ConfigManager.disableLinkerLogs = !ConfigManager.disableLinkerLogs;
                    widget.method_25355(Messages.translateWithFallback(DISABLE_LINKER_LOGS_KEY, getToggledComponent(class_5244.field_24332, class_5244.field_24333, ConfigManager.disableLinkerLogs), DISABLE_LINKER_LOGS_FALBACK));
                    ConfigManager.saveFile();
                })
                .method_46436(class_7919.method_47407(class_2561.method_43471(DISABLE_LINKER_LOGS_KEY + ".tooltip")))
                .method_46434(this.field_22789 / 2 - (class_4185.field_49479 / 2), this.field_22790 / 2 - 20 - (class_4185.field_39501 + 3), class_4185.field_49479, class_4185.field_39501)
                .method_46431()
        );

        this.method_48640();
    }

    public static class_2561 getToggledComponent(class_2561 first, class_2561 second, boolean toggle) {
        return toggle ? first : second;
    }

    @Override
    protected void method_48640() {
        this.headerAndFooterLayout.method_48222();

        this.contentsFlow.method_46421((this.field_22789 / 2) - (contentsFlow.method_25368() / 2));
        this.contentsFlow.method_48222();
    }

    @Override
    public void method_25419() {
        ConfigManager.logCurrentConfig();
        assert this.field_22787 != null;
        this.field_22787.method_1507(parent);
    }

    public static class_437 createConfigScreen(class_437 parent) {
        return new ConfigScreen(parent);
    }
}