/*
 * Decompiled with CFR 0.152.
 */
package com.sekwah.advancedportals.core;

import com.sekwah.advancedportals.core.commands.CommandWithSubCommands;
import com.sekwah.advancedportals.core.commands.SubCommand;
import com.sekwah.advancedportals.core.commands.subcommands.desti.CreateDestiSubCommand;
import com.sekwah.advancedportals.core.commands.subcommands.desti.ListDestiSubCommand;
import com.sekwah.advancedportals.core.commands.subcommands.desti.RemoveDestiSubCommand;
import com.sekwah.advancedportals.core.commands.subcommands.desti.RenameDestiSubCommand;
import com.sekwah.advancedportals.core.commands.subcommands.desti.ShowDestiSubCommand;
import com.sekwah.advancedportals.core.commands.subcommands.desti.TeleportDestiSubCommand;
import com.sekwah.advancedportals.core.commands.subcommands.portal.CreatePortalSubCommand;
import com.sekwah.advancedportals.core.commands.subcommands.portal.DisableBeaconSubCommand;
import com.sekwah.advancedportals.core.commands.subcommands.portal.EndGatewayBlockSubCommand;
import com.sekwah.advancedportals.core.commands.subcommands.portal.EndPortalBlockSubCommand;
import com.sekwah.advancedportals.core.commands.subcommands.portal.InfoPortalSubCommand;
import com.sekwah.advancedportals.core.commands.subcommands.portal.LangUpdateSubCommand;
import com.sekwah.advancedportals.core.commands.subcommands.portal.ListPortalsSubCommand;
import com.sekwah.advancedportals.core.commands.subcommands.portal.PortalBlockSubCommand;
import com.sekwah.advancedportals.core.commands.subcommands.portal.ReloadPortalSubCommand;
import com.sekwah.advancedportals.core.commands.subcommands.portal.RemovePortalSubCommand;
import com.sekwah.advancedportals.core.commands.subcommands.portal.SelectorSubCommand;
import com.sekwah.advancedportals.core.commands.subcommands.portal.ShowPortalSubCommand;
import com.sekwah.advancedportals.core.commands.subcommands.portal.VersionSubCommand;
import com.sekwah.advancedportals.core.connector.commands.CommandRegister;
import com.sekwah.advancedportals.core.connector.containers.PlayerContainer;
import com.sekwah.advancedportals.core.connector.containers.ServerContainer;
import com.sekwah.advancedportals.core.module.AdvancedPortalsModule;
import com.sekwah.advancedportals.core.permissions.Permissions;
import com.sekwah.advancedportals.core.registry.TagRegistry;
import com.sekwah.advancedportals.core.repository.ConfigRepository;
import com.sekwah.advancedportals.core.serializeddata.DataStorage;
import com.sekwah.advancedportals.core.services.DestinationServices;
import com.sekwah.advancedportals.core.services.PlayerDataServices;
import com.sekwah.advancedportals.core.services.PortalServices;
import com.sekwah.advancedportals.core.tags.BungeeTag;
import com.sekwah.advancedportals.core.tags.CommandTag;
import com.sekwah.advancedportals.core.tags.CooldownTag;
import com.sekwah.advancedportals.core.tags.DestiTag;
import com.sekwah.advancedportals.core.tags.MessageTag;
import com.sekwah.advancedportals.core.tags.NameTag;
import com.sekwah.advancedportals.core.tags.PermissionTag;
import com.sekwah.advancedportals.core.tags.PortalEventTag;
import com.sekwah.advancedportals.core.tags.ProxyTag;
import com.sekwah.advancedportals.core.tags.TriggerBlockTag;
import com.sekwah.advancedportals.core.util.GameScheduler;
import com.sekwah.advancedportals.core.util.InfoLogger;
import com.sekwah.advancedportals.core.util.Lang;
import com.sekwah.advancedportals.shadowed.inject.Inject;
import com.sekwah.advancedportals.shadowed.inject.Injector;
import java.io.File;
import java.util.Arrays;

public class AdvancedPortalsCore {
    private final InfoLogger infoLogger;
    private final DataStorage dataStorage;
    private final AdvancedPortalsModule module;
    private final int[] mcVersion;
    private final ServerContainer serverContainer;
    private static AdvancedPortalsCore instance;
    @Inject
    private CommandRegister commandRegister;
    private CommandWithSubCommands portalCommand;
    private CommandWithSubCommands destiCommand;
    @Inject
    private ConfigRepository configRepository;
    @Inject
    private TagRegistry tagRegistry;
    @Inject
    private PortalServices portalServices;
    @Inject
    private DestinationServices destinationServices;
    @Inject
    private PlayerDataServices playerDataRepository;
    @Inject
    private GameScheduler gameScheduler;

    public AdvancedPortalsCore(String mcVersion, File dataStorageLoc, InfoLogger infoLogger, ServerContainer serverContainer) {
        int[] mcVersionTemp;
        instance = this;
        this.serverContainer = serverContainer;
        this.dataStorage = new DataStorage(dataStorageLoc);
        this.infoLogger = infoLogger;
        infoLogger.info("Loading Advanced Portals Core v2.5.0 for MC: " + mcVersion);
        try {
            mcVersionTemp = Arrays.stream(mcVersion.split("\\.")).mapToInt(Integer::parseInt).toArray();
        }
        catch (NumberFormatException e) {
            infoLogger.info("Failed to parse MC version: " + mcVersion);
            e.printStackTrace();
            mcVersionTemp = new int[]{0, 0, 0};
        }
        if (mcVersionTemp.length == 2) {
            mcVersionTemp = new int[]{mcVersionTemp[0], mcVersionTemp[1], 0};
        }
        this.mcVersion = mcVersionTemp;
        this.module = new AdvancedPortalsModule(this);
    }

    public void onEnable() {
        Injector injector = this.module.getInjector();
        injector.injectMembers(this);
        injector.injectMembers(Lang.instance);
        this.dataStorage.copyDefaultFile("lang/en_GB.lang", false);
        this.loadPortalConfig();
        Lang.loadLanguage(this.configRepository.getTranslation());
        this.registerCommands();
        this.registerTags();
        this.registerChannels();
        this.portalServices.loadPortals();
        this.destinationServices.loadDestinations();
        this.infoLogger.info(Lang.translate("logger.pluginenable"));
    }

    private void registerChannels() {
        this.serverContainer.registerOutgoingChannel("BungeeCord");
        if (this.configRepository.getEnableProxySupport()) {
            this.serverContainer.registerOutgoingChannel("advancedportals:message");
            this.serverContainer.registerIncomingChannel("advancedportals:message");
        }
    }

    private void registerTags() {
        this.tagRegistry.registerTag(new NameTag());
        this.tagRegistry.registerTag(new DestiTag());
        this.tagRegistry.registerTag(new CooldownTag());
        this.tagRegistry.registerTag(new TriggerBlockTag());
        this.tagRegistry.registerTag(new PermissionTag());
        this.tagRegistry.registerTag(new CommandTag());
        this.tagRegistry.registerTag(new PortalEventTag());
        this.tagRegistry.registerTag(new MessageTag());
        this.tagRegistry.registerTag(new BungeeTag());
        this.tagRegistry.registerTag(new ProxyTag());
    }

    public void registerCommands() {
        this.registerPortalCommand(this.commandRegister);
        this.registerDestinationCommand(this.commandRegister);
    }

    private void registerPortalCommand(CommandRegister commandRegister) {
        this.portalCommand = new CommandWithSubCommands(this, Permissions.PORTAL);
        this.portalCommand.registerSubCommand("version", new VersionSubCommand(), new String[0]);
        this.portalCommand.registerSubCommand("langupdate", new LangUpdateSubCommand(), new String[0]);
        this.portalCommand.registerSubCommand("reload", new ReloadPortalSubCommand(), new String[0]);
        this.portalCommand.registerSubCommand("selector", new SelectorSubCommand(), "wand");
        this.portalCommand.registerSubCommand("portalblock", new PortalBlockSubCommand(), new String[0]);
        this.portalCommand.registerSubCommand("endportalblock", new EndPortalBlockSubCommand(), new String[0]);
        this.portalCommand.registerSubCommand("endgatewayblock", new EndGatewayBlockSubCommand(), new String[0]);
        this.portalCommand.registerSubCommand("create", new CreatePortalSubCommand(), new String[0]);
        this.portalCommand.registerSubCommand("remove", new RemovePortalSubCommand(), new String[0]);
        this.portalCommand.registerSubCommand("list", new ListPortalsSubCommand(), new String[0]);
        this.portalCommand.registerSubCommand("show", new ShowPortalSubCommand(), new String[0]);
        this.portalCommand.registerSubCommand("info", new InfoPortalSubCommand(), new String[0]);
        this.portalCommand.registerSubCommand("disablebeacon", new DisableBeaconSubCommand(), new String[0]);
        commandRegister.registerCommand("portal", this.portalCommand);
    }

    private void registerDestinationCommand(CommandRegister commandRegister) {
        this.destiCommand = new CommandWithSubCommands(this, Permissions.DESTI);
        this.destiCommand.registerSubCommand("create", new CreateDestiSubCommand(), new String[0]);
        this.destiCommand.registerSubCommand("remove", new RemoveDestiSubCommand(), new String[0]);
        this.destiCommand.registerSubCommand("rename", new RenameDestiSubCommand(), new String[0]);
        this.destiCommand.registerSubCommand("teleport", new TeleportDestiSubCommand(), "tp", "warp");
        this.destiCommand.registerSubCommand("list", new ListDestiSubCommand(), new String[0]);
        this.destiCommand.registerSubCommand("show", new ShowDestiSubCommand(), new String[0]);
        commandRegister.registerCommand("destination", this.destiCommand);
    }

    public boolean registerPortalCommand(String arg, SubCommand subCommand, String ... aliasArgs) {
        return this.portalCommand.registerSubCommand(arg, subCommand, aliasArgs);
    }

    public boolean registerDestiCommand(String arg, SubCommand subCommand, String ... aliasArgs) {
        return this.destiCommand.registerSubCommand(arg, subCommand, aliasArgs);
    }

    public void loadPortalConfig() {
        this.configRepository.loadConfig(this.dataStorage);
        this.configRepository.storeConfig();
    }

    public void onDisable() {
        for (PlayerContainer playerContainer : this.serverContainer.getPlayers()) {
            this.playerDataRepository.playerLeave(playerContainer);
        }
        this.infoLogger.info(Lang.translate("logger.plugindisable"));
    }

    public InfoLogger getInfoLogger() {
        return this.infoLogger;
    }

    public DataStorage getDataStorage() {
        return this.dataStorage;
    }

    public AdvancedPortalsModule getModule() {
        return this.module;
    }

    public TagRegistry getTagRegistry() {
        return this.tagRegistry;
    }

    public GameScheduler getGameScheduler() {
        return this.gameScheduler;
    }

    public int[] getMcVersion() {
        return this.mcVersion;
    }

    public static AdvancedPortalsCore getInstance() {
        return instance;
    }

    public ServerContainer getServerContainer() {
        return this.serverContainer;
    }
}

