/*
 * Decompiled with CFR 0.152.
 */
package com.sekwah.advancedportals.core;

import com.sekwah.advancedportals.core.connector.containers.EntityContainer;
import com.sekwah.advancedportals.core.connector.containers.PlayerContainer;
import com.sekwah.advancedportals.core.connector.containers.WorldContainer;
import com.sekwah.advancedportals.core.data.BlockAxis;
import com.sekwah.advancedportals.core.data.Direction;
import com.sekwah.advancedportals.core.network.ServerDestiPacket;
import com.sekwah.advancedportals.core.permissions.Permissions;
import com.sekwah.advancedportals.core.repository.ConfigRepository;
import com.sekwah.advancedportals.core.serializeddata.BlockLocation;
import com.sekwah.advancedportals.core.serializeddata.PlayerData;
import com.sekwah.advancedportals.core.serializeddata.PlayerLocation;
import com.sekwah.advancedportals.core.services.DestinationServices;
import com.sekwah.advancedportals.core.services.PlayerDataServices;
import com.sekwah.advancedportals.core.services.PortalServices;
import com.sekwah.advancedportals.core.util.GameScheduler;
import com.sekwah.advancedportals.core.util.Lang;
import com.sekwah.advancedportals.core.warphandler.TriggerType;
import com.sekwah.advancedportals.shadowed.guava.io.ByteArrayDataInput;
import com.sekwah.advancedportals.shadowed.guava.io.ByteStreams;
import com.sekwah.advancedportals.shadowed.inject.Inject;
import java.util.Objects;

public class CoreListeners {
    @Inject
    private PlayerDataServices playerDataServices;
    @Inject
    private PortalServices portalServices;
    @Inject
    private DestinationServices destinationServices;
    @Inject
    private ConfigRepository configRepository;
    @Inject
    private GameScheduler gameScheduler;

    public void playerJoin(PlayerContainer player) {
        this.playerDataServices.setJoinCooldown(player);
        this.setIfInPortal(player);
    }

    private void setIfInPortal(PlayerContainer player) {
        String inPortal = this.portalServices.inPortalRegionGetName(player.getBlockLoc());
        if (inPortal == null) {
            inPortal = this.portalServices.inPortalRegionGetName(player.getBlockLoc().addY((int)player.getHeight()));
        }
        this.playerDataServices.getPlayerData(player).setInPortal(inPortal);
    }

    public void teleportEvent(PlayerContainer player) {
        this.playerDataServices.setJoinCooldown(player);
    }

    public void playerLeave(PlayerContainer player) {
        this.playerDataServices.playerLeave(player);
    }

    public void incomingMessage(PlayerContainer player, String channel, byte[] message) {
        String messageType;
        ByteArrayDataInput buffer = ByteStreams.newDataInput(message);
        switch (messageType = buffer.readUTF()) {
            case "server:destination": {
                ServerDestiPacket serverDestiPacket = ServerDestiPacket.decode(buffer);
                this.destinationServices.teleportToDestination(serverDestiPacket.getDestination(), player, true);
            }
        }
    }

    public void tick() {
        this.gameScheduler.tick();
    }

    public void playerMove(PlayerContainer player, PlayerLocation toLoc) {
        this.portalServices.checkPortalActivation(player, toLoc, TriggerType.MOVEMENT);
    }

    public boolean blockBreak(PlayerContainer player, BlockLocation blockPos, String blockMaterial, String itemInHandMaterial, String itemInHandName) {
        if (!this.configRepository.getPortalProtection()) {
            return true;
        }
        if (player == null) {
            return !this.portalServices.inPortalRegionProtected(blockPos);
        }
        if (!Permissions.BUILD.hasPermission(player) && this.portalServices.inPortalRegionProtected(blockPos)) {
            player.sendMessage(Lang.getNegativePrefix() + Lang.translate("portal.nobuild"));
            return false;
        }
        return true;
    }

    public boolean blockPlace(PlayerContainer player, BlockLocation blockPos, String blockMaterial, String itemInHandMaterial, String itemInHandName) {
        if (blockPos == null || blockMaterial == null) {
            return false;
        }
        if (player != null && Permissions.BUILD.hasPermission(player)) {
            WorldContainer world = player.getWorld();
            if (itemInHandName != null && itemInHandName.equals("\u00a75Portal Block Placer")) {
                world.setBlock(blockPos, "NETHER_PORTAL");
                for (Direction direction : Direction.values()) {
                    BlockLocation checkLoc = new BlockLocation(blockPos, direction);
                    if (!world.getBlock(checkLoc).equals("NETHER_PORTAL")) continue;
                    world.setBlockAxis(blockPos, world.getBlockAxis(checkLoc));
                    break;
                }
                return true;
            }
            if (itemInHandName != null && itemInHandName.equals("\u00a78End Portal Block Placer")) {
                world.setBlock(blockPos, "END_PORTAL");
                return true;
            }
            if (itemInHandName != null && itemInHandName.equals("\u00a78Gateway Block Placer")) {
                world.setBlock(blockPos, "END_GATEWAY");
                world.disableBeacon(blockPos);
                return true;
            }
            return true;
        }
        if (this.portalServices.inPortalRegionProtected(blockPos)) {
            if (player != null) {
                player.sendMessage(Lang.getNegativePrefix() + Lang.translate("portal.nobuild"));
            }
            return false;
        }
        return true;
    }

    public boolean blockInteract(PlayerContainer player, BlockLocation blockPos) {
        return true;
    }

    public boolean playerInteractWithBlock(PlayerContainer player, String blockMaterialname, String itemMaterialName, String itemName, BlockLocation blockLoc, boolean leftClick) {
        if (itemName != null && Permissions.CREATE_PORTAL.hasPermission(player) && itemMaterialName.equalsIgnoreCase(this.configRepository.getSelectorMaterial()) && (!this.configRepository.getUseOnlySpecialAxe() || itemName.equals("\u00a7ePortal Region Selector"))) {
            this.playerDataServices.playerSelectorActivate(player, blockLoc, leftClick);
            return false;
        }
        if (itemName != null && leftClick && Objects.equals(itemMaterialName, "PURPLE_WOOL") && itemName.equals("\u00a75Portal Block Placer") && Permissions.BUILD.hasPermission(player)) {
            if (!Objects.equals(blockMaterialname, "NETHER_PORTAL")) {
                return false;
            }
            WorldContainer world = player.getWorld();
            if (world.getBlockAxis(blockLoc) == BlockAxis.X) {
                world.setBlockAxis(blockLoc, BlockAxis.Z);
            } else {
                world.setBlockAxis(blockLoc, BlockAxis.X);
            }
            return false;
        }
        return true;
    }

    public void worldChange(PlayerContainer player) {
        this.playerDataServices.setJoinCooldown(player);
        this.setIfInPortal(player);
    }

    public boolean preventEntityCombust(EntityContainer entity) {
        return this.portalServices.inPortalRegion(entity.getBlockLoc(), 2);
    }

    public boolean entityPortalEvent(EntityContainer entity) {
        PlayerContainer player;
        PlayerData playerData;
        BlockLocation pos = entity.getBlockLoc();
        if (entity instanceof PlayerContainer && (playerData = this.playerDataServices.getPlayerData(player = (PlayerContainer)entity)).getPortalBlockCooldown()) {
            return false;
        }
        return !this.portalServices.inPortalRegion(pos, 1) && !this.portalServices.inPortalRegion(pos.addY((int)entity.getHeight()), 1);
    }

    public boolean playerPortalEvent(PlayerContainer player, PlayerLocation toLoc) {
        PlayerData playerData = this.playerDataServices.getPlayerData(player);
        if (playerData.getPortalBlockCooldown()) {
            return false;
        }
        PortalServices.PortalActivationResult portalResult = this.portalServices.checkPortalActivation(player, toLoc, TriggerType.PORTAL);
        if (portalResult != PortalServices.PortalActivationResult.NOT_IN_PORTAL) {
            return false;
        }
        BlockLocation pos = player.getBlockLoc();
        boolean feetInPortal = this.portalServices.inPortalRegion(pos, 1);
        boolean headInPortal = this.portalServices.inPortalRegion(pos.addY((int)player.getHeight()), 1);
        return !feetInPortal && !headInPortal;
    }

    public boolean physicsEvent(BlockLocation blockLocation, String string) {
        return !this.configRepository.getDisablePhysicsEvents() || !this.portalServices.inPortalRegionProtected(blockLocation);
    }
}

