/*
 * Decompiled with CFR 0.152.
 */
package com.sekwah.advancedportals.core.commands.subcommands.common;

import com.sekwah.advancedportals.core.commands.SubCommand;
import com.sekwah.advancedportals.core.connector.containers.CommandSenderContainer;
import com.sekwah.advancedportals.core.serializeddata.DataTag;
import com.sekwah.advancedportals.core.util.TagReader;
import com.sekwah.advancedportals.core.warphandler.Tag;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public abstract class CreateTaggedSubCommand
implements SubCommand {
    protected abstract List<Tag> getRelatedTags();

    @Override
    public List<String> onTabComplete(CommandSenderContainer sender, String[] args) {
        String lastArg;
        String[] split;
        if (TagReader.isClosedString(args)) {
            return Collections.emptyList();
        }
        List<Tag> allTags = this.getRelatedTags();
        ArrayList<String> suggestions = new ArrayList<String>();
        if (args.length > 0 && ((split = (lastArg = args[args.length - 1]).split(":")).length == 2 || split.length == 1 && lastArg.endsWith(":"))) {
            for (Tag tag2 : allTags) {
                String argData;
                Tag.AutoComplete autoComplete;
                List<String> tagSuggestions;
                boolean startsWith = false;
                if (lastArg.startsWith(tag2.getName())) {
                    startsWith = true;
                } else {
                    String[] aliases = tag2.getAliases();
                    if (aliases != null) {
                        for (String alias : aliases) {
                            if (!lastArg.startsWith(alias)) continue;
                            startsWith = true;
                            break;
                        }
                    }
                }
                if (!(tag2 instanceof Tag.AutoComplete) || !startsWith || (tagSuggestions = (autoComplete = (Tag.AutoComplete)tag2).autoComplete(argData = split.length == 2 ? split[1] : "")) == null) continue;
                if (tag2 instanceof Tag.Split) {
                    Tag.Split splitTag = (Tag.Split)tag2;
                    String multiTagSplit = splitTag.splitString();
                    boolean endsWithSplit = argData.endsWith(multiTagSplit);
                    String[] items = argData.split(multiTagSplit);
                    Set existingItems = Arrays.stream(items, 0, endsWithSplit ? items.length : items.length - 1).map(String::trim).collect(Collectors.toSet());
                    String partialInput = endsWithSplit ? "" : items[items.length - 1].trim();
                    String baseString = endsWithSplit ? argData : argData.substring(0, argData.lastIndexOf(multiTagSplit) + 1);
                    tagSuggestions = tagSuggestions.stream().filter(s -> !existingItems.contains(s)).filter(s -> s.startsWith(partialInput)).map(s -> baseString + s).collect(Collectors.toList());
                }
                for (String tagSuggestion : tagSuggestions) {
                    suggestions.add(split[0] + ":" + tagSuggestion);
                }
            }
            return suggestions;
        }
        ArrayList<DataTag> tagsFromArgs = TagReader.getTagsFromArgs(args);
        allTags.stream().filter(tag -> {
            for (DataTag argTag : tagsFromArgs) {
                if (argTag.NAME.equals(tag.getName())) {
                    return false;
                }
                String[] aliases = tag.getAliases();
                if (aliases == null) continue;
                for (String alias : aliases) {
                    if (!argTag.NAME.equals(alias)) continue;
                    return false;
                }
            }
            return true;
        }).forEach(tag -> {
            suggestions.add(tag.getName());
            String[] aliases = tag.getAliases();
            if (aliases != null) {
                suggestions.addAll(Arrays.stream(aliases).collect(Collectors.toList()));
            }
        });
        suggestions.replaceAll(s -> s + ":");
        return suggestions;
    }

    protected void filterAndProcessTags(List<DataTag> dataTags) {
        List<Tag> relatedTags = this.getRelatedTags();
        ArrayList<DataTag> processedTags = new ArrayList<DataTag>();
        block0: for (DataTag dataTag : dataTags) {
            for (Tag tag : relatedTags) {
                Tag.Split splitTag;
                String splitString;
                if (tag instanceof Tag.Split && (splitString = (splitTag = (Tag.Split)tag).splitString()) != null) {
                    ArrayList newValues = new ArrayList();
                    for (String split : dataTag.VALUES) {
                        newValues.addAll(Arrays.stream(split.split(splitString)).map(String::trim).collect(Collectors.toList()));
                    }
                    dataTag = new DataTag(dataTag.NAME, newValues.toArray(new String[0]));
                }
                if (dataTag.NAME.equals(tag.getName())) {
                    processedTags.add(dataTag);
                    continue block0;
                }
                if (tag.getAliases() == null || !Arrays.asList(tag.getAliases()).contains(dataTag.NAME)) continue;
                processedTags.add(new DataTag(tag.getName(), dataTag.VALUES));
                continue block0;
            }
        }
        dataTags.clear();
        dataTags.addAll(processedTags);
        dataTags.sort((o1, o2) -> {
            if (o1.NAME.equals("name")) {
                return -1;
            }
            if (o2.NAME.equals("name")) {
                return 1;
            }
            return o1.NAME.compareTo(o2.NAME);
        });
    }
}

