/*
 * Decompiled with CFR 0.152.
 */
package com.sekwah.advancedportals.core.commands.subcommands.desti;

import com.sekwah.advancedportals.core.AdvancedPortalsCore;
import com.sekwah.advancedportals.core.commands.SubCommand;
import com.sekwah.advancedportals.core.connector.containers.CommandSenderContainer;
import com.sekwah.advancedportals.core.connector.containers.PlayerContainer;
import com.sekwah.advancedportals.core.connector.containers.ServerContainer;
import com.sekwah.advancedportals.core.destination.Destination;
import com.sekwah.advancedportals.core.permissions.Permissions;
import com.sekwah.advancedportals.core.repository.ConfigRepository;
import com.sekwah.advancedportals.core.serializeddata.PlayerData;
import com.sekwah.advancedportals.core.serializeddata.PlayerLocation;
import com.sekwah.advancedportals.core.serializeddata.Vector;
import com.sekwah.advancedportals.core.services.DestinationServices;
import com.sekwah.advancedportals.core.services.PlayerDataServices;
import com.sekwah.advancedportals.core.util.GameScheduler;
import com.sekwah.advancedportals.core.util.Lang;
import com.sekwah.advancedportals.core.util.Matrix;
import com.sekwah.advancedportals.shadowed.inject.Inject;
import java.awt.Color;
import java.util.List;
import java.util.Objects;

public class ShowDestiSubCommand
implements SubCommand,
SubCommand.SubCommandOnInit {
    @Inject
    PlayerDataServices tempDataServices;
    @Inject
    GameScheduler gameScheduler;
    @Inject
    AdvancedPortalsCore core;
    @Inject
    DestinationServices destinationServices;
    @Inject
    ServerContainer serverContainer;
    @Inject
    ConfigRepository config;
    Vector BASE = new Vector(0.0, 0.0, -1.0);
    Vector TIP = new Vector(0.0, 0.0, 1.0);
    Vector LEFT = new Vector(0.7, 0.0, 0.2);
    Vector RIGHT = new Vector(-0.7, 0.0, 0.2);

    @Override
    public void onCommand(CommandSenderContainer sender, String[] args) {
        PlayerData tempData = this.tempDataServices.getPlayerData(sender.getPlayerContainer());
        if (tempData.isDestiVisible()) {
            sender.sendMessage(Lang.getNegativePrefix() + Lang.translate("command.destination.show.disabled"));
        } else {
            sender.sendMessage(Lang.getPositivePrefix() + Lang.translate("command.destination.show.enabled"));
        }
        tempData.setDestiVisible(!tempData.isDestiVisible());
    }

    @Override
    public boolean hasPermission(CommandSenderContainer sender) {
        return Permissions.SHOW_DESTI.hasPermission(sender);
    }

    @Override
    public List<String> onTabComplete(CommandSenderContainer sender, String[] args) {
        return null;
    }

    @Override
    public String getBasicHelpText() {
        return Lang.translate("command.destination.show.help");
    }

    @Override
    public String getDetailedHelpText() {
        return Lang.translate("command.destination.show.detailedhelp");
    }

    @Override
    public void registered() {
        this.gameScheduler.intervalTickEvent("show_portal", () -> {
            for (PlayerContainer player : this.serverContainer.getPlayers()) {
                PlayerData tempData = this.tempDataServices.getPlayerData(player);
                if (!tempData.isDestiVisible()) continue;
                for (Destination destination : this.destinationServices.getDestinations()) {
                    PlayerLocation pos = destination.getLoc();
                    if (!Objects.equals(pos.getWorldName(), player.getWorldName()) || !(pos.distanceTo(player.getLoc()) < (double)this.config.getShowVisibleRange())) continue;
                    this.drawArrow(player, pos, new Color(255, 221, 0));
                }
            }
        }, 1, 5);
    }

    public void drawArrow(PlayerContainer player, PlayerLocation playerLocation, Color color) {
        Matrix rotation = Matrix.identity().rotY(-playerLocation.getYaw()).rotX(playerLocation.getPitch());
        Vector location = playerLocation.add(new Vector(0.0, 1.5, 0.0));
        Vector base = rotation.transform(this.BASE).add(location);
        Vector tip = rotation.transform(this.TIP).add(location);
        Vector left = rotation.transform(this.LEFT).add(location);
        Vector right = rotation.transform(this.RIGHT).add(location);
        player.drawLine(base, tip, color, 0.25f);
        player.drawLine(tip, left, color, 0.25f);
        player.drawLine(tip, right, color, 0.25f);
    }
}

