/*
 * Decompiled with CFR 0.152.
 */
package com.sekwah.advancedportals.core.commands.subcommands.desti;

import com.sekwah.advancedportals.core.commands.SubCommand;
import com.sekwah.advancedportals.core.connector.containers.CommandSenderContainer;
import com.sekwah.advancedportals.core.connector.containers.EntityContainer;
import com.sekwah.advancedportals.core.connector.containers.PlayerContainer;
import com.sekwah.advancedportals.core.permissions.Permissions;
import com.sekwah.advancedportals.core.services.DestinationServices;
import com.sekwah.advancedportals.core.util.Lang;
import com.sekwah.advancedportals.shadowed.inject.Inject;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class TeleportDestiSubCommand
implements SubCommand {
    @Inject
    DestinationServices destinationServices;

    @Override
    public void onCommand(CommandSenderContainer sender, String[] args) {
        if (args.length > 1) {
            if (args.length > 2 && Permissions.TELEPORT_PLAYER_DESTI.hasPermission(sender)) {
                PlayerContainer targetPlayer = sender.getServer().getPlayer(args[2]);
                if (this.destinationServices.teleportToDestination(args[1], targetPlayer)) {
                    sender.sendMessage(Lang.getPositivePrefix() + Lang.translateInsertVariables("command.destination.teleportplayer.success", args[2], args[1]));
                    targetPlayer.sendMessage(Lang.getPositivePrefix() + Lang.translateInsertVariables("command.destination.teleport.success", args[1]).replaceAll("@destiname", args[1]));
                } else {
                    sender.sendMessage(Lang.getNegativePrefix() + Lang.translateInsertVariables("command.destination.teleportplayer.error", args[2], args[1]));
                }
            } else if (this.destinationServices.teleportToDestination(args[1], sender.getPlayerContainer())) {
                sender.sendMessage(Lang.getPositivePrefix() + Lang.translateInsertVariables("command.destination.teleport.success", args[1]).replaceAll("@destiname", args[1]));
            } else {
                sender.sendMessage(Lang.getNegativePrefix() + Lang.translateInsertVariables("command.destination.teleport.error", args[1]).replaceAll("@destiname", args[1]));
            }
        } else {
            sender.sendMessage(Lang.getNegativePrefix() + Lang.translate("command.destination.noname"));
        }
    }

    @Override
    public boolean hasPermission(CommandSenderContainer sender) {
        return Permissions.TELEPORT_DESTI.hasPermission(sender);
    }

    @Override
    public List<String> onTabComplete(CommandSenderContainer sender, String[] args) {
        if (args.length == 2) {
            List<String> destiNames = this.destinationServices.getDestinationNames();
            Collections.sort(destiNames);
            return destiNames;
        }
        if (args.length == 3 && Permissions.TELEPORT_PLAYER_DESTI.hasPermission(sender)) {
            return Arrays.stream(sender.getServer().getPlayers()).map(EntityContainer::getName).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    @Override
    public String getBasicHelpText() {
        return Lang.translate("command.destination.teleport.help");
    }

    @Override
    public String getDetailedHelpText() {
        return Lang.translate("command.destination.teleport.detailedhelp");
    }
}

