/*
 * Decompiled with CFR 0.152.
 */
package com.sekwah.advancedportals.core.commands.subcommands.portal;

import com.sekwah.advancedportals.core.commands.subcommands.common.CreateTaggedSubCommand;
import com.sekwah.advancedportals.core.connector.containers.CommandSenderContainer;
import com.sekwah.advancedportals.core.connector.containers.PlayerContainer;
import com.sekwah.advancedportals.core.permissions.Permissions;
import com.sekwah.advancedportals.core.portal.AdvancedPortal;
import com.sekwah.advancedportals.core.registry.TagRegistry;
import com.sekwah.advancedportals.core.repository.ConfigRepository;
import com.sekwah.advancedportals.core.serializeddata.DataTag;
import com.sekwah.advancedportals.core.services.PortalServices;
import com.sekwah.advancedportals.core.tags.NameTag;
import com.sekwah.advancedportals.core.util.Lang;
import com.sekwah.advancedportals.core.util.TagReader;
import com.sekwah.advancedportals.core.warphandler.Tag;
import com.sekwah.advancedportals.shadowed.inject.Inject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class CreatePortalSubCommand
extends CreateTaggedSubCommand {
    @Inject
    PortalServices portalServices;
    @Inject
    TagRegistry tagRegistry;
    @Inject
    ConfigRepository config;

    @Override
    public void onCommand(CommandSenderContainer sender, String[] args) {
        if (args.length > 1) {
            AdvancedPortal portal;
            PlayerContainer player = sender.getPlayerContainer();
            if (player == null) {
                sender.sendMessage(Lang.getNegativePrefix() + Lang.translate("command.create.console"));
                return;
            }
            ArrayList<DataTag> portalTags = TagReader.getTagsFromArgs(args);
            DataTag nameTag = portalTags.stream().filter(tag -> tag.NAME.equals(NameTag.TAG_NAME)).findFirst().orElse(null);
            if (nameTag == null && !args[1].contains(":")) {
                nameTag = new DataTag("name", args[1]);
                portalTags.add(nameTag);
            }
            if (nameTag == null) {
                sender.sendMessage(Lang.getNegativePrefix() + Lang.translate("command.error.noname"));
                return;
            }
            if (!portalTags.isEmpty()) {
                this.filterAndProcessTags(portalTags);
                TagReader.printArgs(sender, portalTags);
            }
            sender.sendMessage("");
            DataTag triggerBlockTag = portalTags.stream().filter(tag -> tag.NAME.equals("triggerblock")).findFirst().orElse(null);
            if (triggerBlockTag == null) {
                portalTags.add(new DataTag("triggerblock", this.config.getDefaultTriggerBlock()));
            }
            if ((portal = this.portalServices.createPortal(player, portalTags)) != null) {
                sender.sendMessage(Lang.getPositivePrefix() + Lang.translate("command.create.complete"));
                sender.sendMessage(Lang.translate("command.create.tags"));
                TagReader.printArgs(sender, portal.getArgs());
            } else {
                sender.sendMessage(Lang.getNegativePrefix() + Lang.translate("command.create.error"));
            }
        } else {
            sender.sendMessage(Lang.getNegativePrefix() + Lang.translate("command.error.notags"));
        }
    }

    @Override
    public boolean hasPermission(CommandSenderContainer sender) {
        return Permissions.CREATE_PORTAL.hasPermission(sender);
    }

    @Override
    protected List<Tag> getRelatedTags() {
        List<Tag> tags = this.tagRegistry.getTags();
        return tags.stream().filter(tag -> Arrays.asList(tag.getTagTypes()).contains((Object)Tag.TagType.PORTAL)).collect(Collectors.toList());
    }

    @Override
    public String getBasicHelpText() {
        return Lang.translate("command.create.help");
    }

    @Override
    public String getDetailedHelpText() {
        return Lang.translate("command.create.detailedhelp");
    }
}

