/*
 * Decompiled with CFR 0.152.
 */
package com.sekwah.advancedportals.core.commands.subcommands.portal;

import com.sekwah.advancedportals.core.AdvancedPortalsCore;
import com.sekwah.advancedportals.core.commands.SubCommand;
import com.sekwah.advancedportals.core.connector.containers.CommandSenderContainer;
import com.sekwah.advancedportals.core.permissions.Permissions;
import com.sekwah.advancedportals.core.repository.ConfigRepository;
import com.sekwah.advancedportals.core.util.Lang;
import com.sekwah.advancedportals.shadowed.inject.Inject;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class LangUpdateSubCommand
implements SubCommand {
    @Inject
    private AdvancedPortalsCore portalsCore;
    @Inject
    private ConfigRepository configRepository;

    @Override
    public void onCommand(CommandSenderContainer sender, String[] args) {
        if (args.length > 1 && args[1].equalsIgnoreCase("overwrite")) {
            this.portalsCore.getDataStorage().copyDefaultFile("lang/" + this.configRepository.getTranslation() + ".lang", true);
            sender.sendMessage(Lang.getPositivePrefix() + Lang.translate("translatedata.replaced"));
            Lang.loadLanguage(this.configRepository.getTranslation());
        } else {
            Lang lang = Lang.instance;
            Map<String, String> internalTranslation = lang.getInternalLanguageMap("en_GB");
            internalTranslation.putAll(lang.getInternalLanguageMap(this.configRepository.getTranslation()));
            Map<String, String> currentTranslation = lang.getLanguageMap(this.configRepository.getTranslation());
            for (Map.Entry<String, String> entry : currentTranslation.entrySet()) {
                internalTranslation.remove(entry.getKey());
            }
            ArrayList<String> newTranslations = new ArrayList<String>();
            for (Map.Entry<String, String> entry : internalTranslation.entrySet()) {
                newTranslations.add(entry.getKey() + "=" + entry.getValue());
            }
            String string = String.join((CharSequence)"\n", newTranslations);
            InputStream inputStream = this.portalsCore.getDataStorage().loadResource("lang/" + this.configRepository.getTranslation() + ".lang");
            String result = new BufferedReader(new InputStreamReader(inputStream)).lines().collect(Collectors.joining("\n"));
            ByteArrayInputStream withExtras = new ByteArrayInputStream(result.concat("\n").concat(string).getBytes());
            this.portalsCore.getDataStorage().writeResource(withExtras, "lang/" + this.configRepository.getTranslation() + ".lang");
            Lang.loadLanguage(this.configRepository.getTranslation());
            sender.sendMessage(Lang.getPositivePrefix() + Lang.translateInsertVariables("translatedata.updated", newTranslations.size()));
        }
    }

    @Override
    public boolean hasPermission(CommandSenderContainer sender) {
        return Permissions.LANG_UPDATE.hasPermission(sender);
    }

    @Override
    public List<String> onTabComplete(CommandSenderContainer sender, String[] args) {
        return null;
    }

    @Override
    public String getBasicHelpText() {
        return Lang.translate("command.lang.help");
    }

    @Override
    public String getDetailedHelpText() {
        return Lang.translate("command.lang.help");
    }
}

