/*
 * Decompiled with CFR 0.152.
 */
package com.sekwah.advancedportals.core.commands.subcommands.portal;

import com.sekwah.advancedportals.core.AdvancedPortalsCore;
import com.sekwah.advancedportals.core.commands.SubCommand;
import com.sekwah.advancedportals.core.connector.containers.CommandSenderContainer;
import com.sekwah.advancedportals.core.permissions.Permissions;
import com.sekwah.advancedportals.core.repository.ConfigRepository;
import com.sekwah.advancedportals.core.services.DestinationServices;
import com.sekwah.advancedportals.core.services.PortalServices;
import com.sekwah.advancedportals.core.util.Lang;
import com.sekwah.advancedportals.shadowed.inject.Inject;
import java.util.List;

public class ReloadPortalSubCommand
implements SubCommand {
    @Inject
    private AdvancedPortalsCore portalsCore;
    @Inject
    PortalServices portalServices;
    @Inject
    DestinationServices destinationServices;
    @Inject
    ConfigRepository configRepository;

    @Override
    public void onCommand(CommandSenderContainer sender, String[] args) {
        this.portalsCore.loadPortalConfig();
        this.portalServices.loadPortals();
        this.destinationServices.loadDestinations();
        Lang.loadLanguage(this.configRepository.getTranslation());
        sender.sendMessage(Lang.getPositivePrefix() + Lang.translate("command.reload.reloaded"));
    }

    @Override
    public boolean hasPermission(CommandSenderContainer sender) {
        return Permissions.RELOAD.hasPermission(sender);
    }

    @Override
    public List<String> onTabComplete(CommandSenderContainer sender, String[] args) {
        return null;
    }

    @Override
    public String getBasicHelpText() {
        return Lang.translate("command.reload.help");
    }

    @Override
    public String getDetailedHelpText() {
        return Lang.translate("command.reload.detailedhelp");
    }
}

