/*
 * Decompiled with CFR 0.152.
 */
package com.sekwah.advancedportals.core.commands.subcommands.portal;

import com.sekwah.advancedportals.core.AdvancedPortalsCore;
import com.sekwah.advancedportals.core.commands.SubCommand;
import com.sekwah.advancedportals.core.connector.containers.CommandSenderContainer;
import com.sekwah.advancedportals.core.connector.containers.PlayerContainer;
import com.sekwah.advancedportals.core.connector.containers.ServerContainer;
import com.sekwah.advancedportals.core.connector.containers.WorldContainer;
import com.sekwah.advancedportals.core.permissions.Permissions;
import com.sekwah.advancedportals.core.portal.AdvancedPortal;
import com.sekwah.advancedportals.core.repository.ConfigRepository;
import com.sekwah.advancedportals.core.serializeddata.BlockLocation;
import com.sekwah.advancedportals.core.serializeddata.PlayerData;
import com.sekwah.advancedportals.core.serializeddata.Vector;
import com.sekwah.advancedportals.core.services.PlayerDataServices;
import com.sekwah.advancedportals.core.services.PortalServices;
import com.sekwah.advancedportals.core.util.GameScheduler;
import com.sekwah.advancedportals.core.util.Lang;
import com.sekwah.advancedportals.shadowed.inject.Inject;
import java.awt.Color;
import java.util.List;
import java.util.Objects;

public class ShowPortalSubCommand
implements SubCommand,
SubCommand.SubCommandOnInit {
    boolean alternate_show_trigger = true;
    @Inject
    PlayerDataServices playerDataServices;
    @Inject
    GameScheduler gameScheduler;
    @Inject
    AdvancedPortalsCore core;
    @Inject
    ServerContainer serverContainer;
    @Inject
    PortalServices portalServices;
    @Inject
    ConfigRepository config;
    final Color POS1_COLOR = new Color(0, 255, 0);
    final Color POS2_COLOR = new Color(255, 0, 0);
    final Color SELECTION_COLOR = new Color(166, 166, 166, 255);
    final Color OUTLINE_COLOR = new Color(0, 255, 0, 100);
    final Color TRIGGER_COLOR = new Color(0, 0, 255, 100);
    final Vector OFFSET = new Vector(0.5, 0.5, 0.5);

    @Override
    public void onCommand(CommandSenderContainer sender, String[] args) {
        PlayerData tempData = this.playerDataServices.getPlayerData(sender.getPlayerContainer());
        if (tempData.isPortalVisible()) {
            sender.sendMessage(Lang.getNegativePrefix() + Lang.translate("command.portal.show.disabled"));
        } else {
            sender.sendMessage(Lang.getPositivePrefix() + Lang.translate("command.portal.show.enabled"));
        }
        tempData.setPortalVisible(!tempData.isPortalVisible());
    }

    @Override
    public boolean hasPermission(CommandSenderContainer sender) {
        return Permissions.SHOW_PORTAL.hasPermission(sender);
    }

    @Override
    public List<String> onTabComplete(CommandSenderContainer sender, String[] args) {
        return null;
    }

    @Override
    public String getBasicHelpText() {
        return Lang.translate("command.portal.show.help");
    }

    @Override
    public String getDetailedHelpText() {
        return Lang.translate("command.portal.show.detailedhelp");
    }

    @Override
    public void registered() {
        this.gameScheduler.intervalTickEvent("show_portal", () -> {
            this.alternate_show_trigger = !this.alternate_show_trigger;
            for (PlayerContainer player : this.serverContainer.getPlayers()) {
                int widthZ;
                int widthY;
                int widthX;
                int totalBlocks;
                PlayerData tempData = this.playerDataServices.getPlayerData(player);
                if (!tempData.isPortalVisible()) continue;
                BlockLocation pos1 = tempData.getPos1();
                BlockLocation pos2 = tempData.getPos2();
                if (pos1 != null && pos2 != null && pos1.getWorldName().equals(player.getWorldName()) && pos2.getWorldName().equals(player.getWorldName()) && (totalBlocks = (widthX = Math.abs(pos1.getPosX() - pos2.getPosX())) * (widthY = Math.abs(pos1.getPosY() - pos2.getPosY())) * (widthZ = Math.abs(pos1.getPosZ() - pos2.getPosZ()))) <= this.config.maxPortalVisualisationSize()) {
                    this.debugVisuals(player, pos1, pos2, this.SELECTION_COLOR);
                }
                if (pos1 != null && pos1.getWorldName().equals(player.getWorldName())) {
                    this.drawBox(player, pos1, pos1, this.POS1_COLOR, 0.25f);
                }
                if (pos2 != null && pos2.getWorldName().equals(player.getWorldName())) {
                    this.drawBox(player, pos2, pos2, this.POS2_COLOR, 0.25f);
                }
                if (pos1 != null && pos2 != null && pos1.getWorldName().equals(player.getWorldName()) && pos2.getWorldName().equals(player.getWorldName()) && pos1.distanceTo(pos2) <= (double)this.config.maxSelectionVisualisationSize()) {
                    this.drawBox(player, pos1, pos2, this.SELECTION_COLOR, 1.0f);
                }
                for (AdvancedPortal portal : this.portalServices.getPortals()) {
                    if (!Objects.equals(portal.getMinLoc().getWorldName(), player.getWorldName()) || !portal.isLocationInPortal(player.getLoc(), this.config.getShowVisibleRange())) continue;
                    this.debugVisuals(player, portal, this.OUTLINE_COLOR, this.TRIGGER_COLOR);
                }
            }
        }, 1, 5);
    }

    private void debugVisuals(PlayerContainer player, BlockLocation pos1, BlockLocation pos2, Color color) {
        this.debugVisuals(player, pos1, pos2, color, null, null);
    }

    private void debugVisuals(PlayerContainer player, AdvancedPortal portal, Color color, Color triggerColor) {
        this.debugVisuals(player, portal.getMinLoc(), portal.getMaxLoc(), color, triggerColor, portal);
    }

    private void drawBox(PlayerContainer player, BlockLocation pos1, BlockLocation pos2, Color color, float particleDensity) {
        int minX = Math.min(pos1.getPosX(), pos2.getPosX());
        int minY = Math.min(pos1.getPosY(), pos2.getPosY());
        int minZ = Math.min(pos1.getPosZ(), pos2.getPosZ());
        int maxX = Math.max(pos1.getPosX(), pos2.getPosX()) + 1;
        int maxY = Math.max(pos1.getPosY(), pos2.getPosY()) + 1;
        int maxZ = Math.max(pos1.getPosZ(), pos2.getPosZ()) + 1;
        player.drawLine(new Vector(minX, maxY, maxZ), new Vector(maxX, maxY, maxZ), color, particleDensity);
        player.drawLine(new Vector(minX, minY, minZ), new Vector(maxX, minY, minZ), color, particleDensity);
        player.drawLine(new Vector(minX, minY, minZ), new Vector(minX, maxY, minZ), color, particleDensity);
        player.drawLine(new Vector(maxX, minY, maxZ), new Vector(maxX, maxY, maxZ), color, particleDensity);
        player.drawLine(new Vector(maxX, maxY, minZ), new Vector(maxX, maxY, maxZ), color, particleDensity);
        player.drawLine(new Vector(minX, minY, minZ), new Vector(minX, minY, maxZ), color, particleDensity);
        player.drawLine(new Vector(maxX, minY, minZ), new Vector(maxX, maxY, minZ), color, particleDensity);
        player.drawLine(new Vector(maxX, minY, minZ), new Vector(maxX, minY, maxZ), color, particleDensity);
        player.drawLine(new Vector(minX, maxY, minZ), new Vector(maxX, maxY, minZ), color, particleDensity);
        player.drawLine(new Vector(minX, maxY, minZ), new Vector(minX, maxY, maxZ), color, particleDensity);
        player.drawLine(new Vector(minX, minY, maxZ), new Vector(maxX, minY, maxZ), color, particleDensity);
        player.drawLine(new Vector(minX, minY, maxZ), new Vector(minX, maxY, maxZ), color, particleDensity);
    }

    private void debugVisuals(PlayerContainer player, BlockLocation pos1, BlockLocation pos2, Color color, Color triggerColor, AdvancedPortal portal) {
        int minX = Math.min(pos1.getPosX(), pos2.getPosX());
        int minY = Math.min(pos1.getPosY(), pos2.getPosY());
        int minZ = Math.min(pos1.getPosZ(), pos2.getPosZ());
        int maxX = Math.max(pos1.getPosX(), pos2.getPosX());
        int maxY = Math.max(pos1.getPosY(), pos2.getPosY());
        int maxZ = Math.max(pos1.getPosZ(), pos2.getPosZ());
        int size = pos1.getSize(pos2);
        WorldContainer world = player.getWorld();
        if (size <= this.config.maxPortalVisualisationSize()) {
            this.drawBox(player, pos1, pos2, color, 0.5f);
            for (int x = minX; x <= maxX; ++x) {
                for (int y = minY; y <= maxY; ++y) {
                    for (int z = minZ; z <= maxZ; ++z) {
                        boolean isTrigger;
                        BlockLocation pos = new BlockLocation(pos1.getWorldName(), x, y, z);
                        boolean bl = isTrigger = portal != null && portal.isTriggerBlock(world.getBlock(pos));
                        if (!isTrigger || !this.alternate_show_trigger) continue;
                        player.spawnColoredDust(pos.toVector().add(this.OFFSET), 0.2, 0.2, 0.2, 1, triggerColor);
                    }
                }
            }
        }
    }
}

