/*
 * Decompiled with CFR 0.152.
 */
package com.sekwah.advancedportals.core.destination;

import com.sekwah.advancedportals.core.connector.containers.PlayerContainer;
import com.sekwah.advancedportals.core.registry.TagRegistry;
import com.sekwah.advancedportals.core.registry.TagTarget;
import com.sekwah.advancedportals.core.serializeddata.DataTag;
import com.sekwah.advancedportals.core.serializeddata.PlayerLocation;
import com.sekwah.advancedportals.core.warphandler.ActivationData;
import com.sekwah.advancedportals.core.warphandler.Tag;
import com.sekwah.advancedportals.core.warphandler.TriggerType;
import com.sekwah.advancedportals.shadowed.inject.Inject;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Destination
implements TagTarget {
    @Inject
    transient TagRegistry tagRegistry;
    private PlayerLocation loc;
    private HashMap<String, String[]> args = new HashMap();
    private transient List<DataTag> destiTags = new ArrayList<DataTag>();
    private transient boolean isSorted = false;

    public Destination() {
        this.loc = new PlayerLocation();
    }

    public Destination(PlayerLocation loc) {
        this.loc = loc;
    }

    @Override
    public String[] getArgValues(String argName) {
        return this.args.get(argName);
    }

    @Override
    public void setArgValues(String argName, String[] argValue) {
        this.isSorted = false;
        this.args.put(argName, argValue);
    }

    @Override
    public void addArg(String argName, String argValues) {
        this.isSorted = false;
    }

    public void setArgValues(DataTag portalTag) {
        this.isSorted = false;
        this.setArgValues(portalTag.NAME, portalTag.VALUES);
    }

    @Override
    public void removeArg(String arg) {
        this.isSorted = false;
        this.args.remove(arg);
    }

    private void updateDestiTagList() {
        this.destiTags.clear();
        for (Map.Entry<String, String[]> entry : this.args.entrySet()) {
            this.destiTags.add(new DataTag(entry.getKey(), entry.getValue()));
        }
        this.destiTags.sort(Comparator.comparingInt(o -> {
            Tag tag = this.tagRegistry.getTag(o.NAME);
            if (tag instanceof Tag.OrderPriority) {
                Tag.OrderPriority tagPriority = (Tag.OrderPriority)((Object)tag);
                return tagPriority.getPriority().ordinal();
            }
            return Tag.Priority.NORMAL.ordinal();
        }));
        this.isSorted = true;
    }

    public boolean activate(PlayerContainer player) {
        ActivationData data = new ActivationData(TriggerType.MANUAL);
        if (this.portalActivate(player, data)) {
            this.postActivate(player, data);
            return true;
        }
        return false;
    }

    public boolean portalActivate(PlayerContainer player, ActivationData data) {
        Tag.Activation activationHandler;
        if (!this.isSorted) {
            this.updateDestiTagList();
        }
        DataTag[] destiTags = new DataTag[this.args.size()];
        int i = 0;
        for (Map.Entry<String, String[]> entry : this.args.entrySet()) {
            destiTags[i++] = new DataTag(entry.getKey(), entry.getValue());
        }
        for (DataTag destiTag : destiTags) {
            activationHandler = this.tagRegistry.getActivationHandler(destiTag.NAME, Tag.TagType.DESTINATION);
            if (activationHandler == null || activationHandler.preActivated(this, player, data, this.getArgValues(destiTag.NAME))) continue;
            return false;
        }
        for (DataTag destiTag : destiTags) {
            activationHandler = this.tagRegistry.getActivationHandler(destiTag.NAME, Tag.TagType.DESTINATION);
            if (activationHandler == null) continue;
            activationHandler.activated(this, player, data, this.getArgValues(destiTag.NAME));
        }
        return true;
    }

    public void postActivate(PlayerContainer player, ActivationData data) {
        DataTag[] destiTags = new DataTag[this.args.size()];
        int i = 0;
        for (Map.Entry<String, String[]> entry : this.args.entrySet()) {
            destiTags[i++] = new DataTag(entry.getKey(), entry.getValue());
        }
        for (DataTag destiTag : destiTags) {
            Tag.Activation activationHandler = this.tagRegistry.getActivationHandler(destiTag.NAME, Tag.TagType.DESTINATION);
            if (activationHandler == null) continue;
            activationHandler.postActivated(this, player, data, this.getArgValues(destiTag.NAME));
        }
    }

    public ArrayList<DataTag> getArgs() {
        ArrayList<DataTag> tagList = new ArrayList<DataTag>();
        for (Map.Entry<String, String[]> entry : this.args.entrySet()) {
            tagList.add(new DataTag(entry.getKey(), entry.getValue()));
        }
        return tagList;
    }

    public String getName() {
        return this.getArgValues("name")[0];
    }

    public PlayerLocation getLoc() {
        return this.loc;
    }

    public void setLoc(PlayerLocation loc) {
        this.loc = loc;
    }
}

