/*
 * Decompiled with CFR 0.152.
 */
package com.sekwah.advancedportals.core.module;

import com.sekwah.advancedportals.core.AdvancedPortalsCore;
import com.sekwah.advancedportals.core.connector.containers.ServerContainer;
import com.sekwah.advancedportals.core.registry.TagRegistry;
import com.sekwah.advancedportals.core.registry.WarpEffectRegistry;
import com.sekwah.advancedportals.core.repository.ConfigRepository;
import com.sekwah.advancedportals.core.repository.IDestinationRepository;
import com.sekwah.advancedportals.core.repository.IPlayerDataRepository;
import com.sekwah.advancedportals.core.repository.IPortalRepository;
import com.sekwah.advancedportals.core.repository.impl.ConfigRepositoryImpl;
import com.sekwah.advancedportals.core.repository.impl.DestinationRepositoryImpl;
import com.sekwah.advancedportals.core.repository.impl.PlayerDataRepositoryImpl;
import com.sekwah.advancedportals.core.repository.impl.PortalRepositoryImpl;
import com.sekwah.advancedportals.core.serializeddata.DataStorage;
import com.sekwah.advancedportals.core.serializeddata.config.Config;
import com.sekwah.advancedportals.core.serializeddata.config.ConfigProvider;
import com.sekwah.advancedportals.core.util.InfoLogger;
import com.sekwah.advancedportals.shadowed.inject.AbstractModule;
import com.sekwah.advancedportals.shadowed.inject.Guice;
import com.sekwah.advancedportals.shadowed.inject.Injector;
import com.sekwah.advancedportals.shadowed.inject.Scopes;
import com.sekwah.advancedportals.shadowed.javax.annotation.Nonnull;
import java.util.ArrayList;
import java.util.List;

public class AdvancedPortalsModule
extends AbstractModule {
    private Injector injector;
    private AdvancedPortalsCore advancedPortalsCore;
    private DataStorage dataStorage;
    private List<DelayedBinding> delayedBindings = new ArrayList<DelayedBinding>();

    public AdvancedPortalsModule(AdvancedPortalsCore advancedPortalsCore) {
        this.advancedPortalsCore = advancedPortalsCore;
    }

    @Override
    protected void configure() {
        this.bind(IPortalRepository.class).to(PortalRepositoryImpl.class).in(Scopes.SINGLETON);
        this.bind(IDestinationRepository.class).to(DestinationRepositoryImpl.class).in(Scopes.SINGLETON);
        this.bind(IPlayerDataRepository.class).to(PlayerDataRepositoryImpl.class).in(Scopes.SINGLETON);
        this.bind(ConfigRepository.class).to(ConfigRepositoryImpl.class).in(Scopes.SINGLETON);
        this.bind(AdvancedPortalsCore.class).toInstance(this.advancedPortalsCore);
        this.bind(InfoLogger.class).toInstance(this.advancedPortalsCore.getInfoLogger());
        this.bind(DataStorage.class).toInstance(this.advancedPortalsCore.getDataStorage());
        this.bind(ServerContainer.class).toInstance(this.advancedPortalsCore.getServerContainer());
        this.bind(Config.class).toProvider(ConfigProvider.class);
        this.bind(TagRegistry.class).asEagerSingleton();
        this.bind(WarpEffectRegistry.class).asEagerSingleton();
        for (DelayedBinding delayedBinding : this.delayedBindings) {
            this.bind(delayedBinding.clazz).toInstance(delayedBinding.instance);
        }
    }

    public <T> void addInstanceBinding(Class<T> clazz, T instance) {
        this.delayedBindings.add(new DelayedBinding<T>(clazz, instance));
    }

    @Nonnull
    public Injector getInjector() {
        if (this.injector == null) {
            this.injector = Guice.createInjector(this);
        }
        return this.injector;
    }

    class DelayedBinding<T> {
        private final T instance;
        private final Class<T> clazz;

        public DelayedBinding(Class<T> clazz, T instance) {
            this.clazz = clazz;
            this.instance = instance;
        }
    }
}

