/*
 * Decompiled with CFR 0.152.
 */
package com.sekwah.advancedportals.core.permissions;

import com.sekwah.advancedportals.core.connector.containers.HasPermission;
import com.sekwah.advancedportals.core.permissions.Permissions;
import com.sekwah.advancedportals.shadowed.guava.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;

public class PermissionBuilder {
    private final String permissionTag;
    private final PermissionDefault permissionDefault;
    private final PermissionBuilder parent;
    private final List<PermissionBuilder> children = new ArrayList<PermissionBuilder>();
    private final List<PermissionBuilder> grantChildren = new ArrayList<PermissionBuilder>();
    private String description;
    private boolean doNotExport = false;

    PermissionBuilder(String permissionTag) {
        this.permissionTag = permissionTag;
        this.parent = null;
        this.permissionDefault = PermissionDefault.FALSE;
    }

    PermissionBuilder(String permissionTag, PermissionBuilder parent) {
        this.permissionTag = permissionTag;
        this.parent = parent;
        this.permissionDefault = parent.permissionDefault;
    }

    PermissionBuilder(String permissionTag, PermissionBuilder parent, PermissionDefault permissionDefault) {
        this.permissionTag = permissionTag;
        this.parent = parent;
        this.permissionDefault = permissionDefault;
    }

    PermissionBuilder(String permissionTag, PermissionDefault permissionDefault) {
        this.permissionTag = permissionTag;
        this.parent = null;
        this.permissionDefault = permissionDefault;
    }

    public PermissionDefault getPermissionDefault() {
        return this.permissionDefault;
    }

    public PermissionBuilder createChild(String permissionTag) {
        PermissionBuilder child = new PermissionBuilder(permissionTag, this);
        this.children.add(child);
        return child;
    }

    public PermissionBuilder createChild(String permissionTag, PermissionDefault permissionDefault) {
        PermissionBuilder child = new PermissionBuilder(permissionTag, this, permissionDefault);
        this.children.add(child);
        return child;
    }

    public PermissionBuilder addGrantChild(PermissionBuilder child) {
        this.grantChildren.add(child);
        return this;
    }

    public PermissionBuilder doNotExport() {
        this.doNotExport = true;
        return this;
    }

    public String toString() {
        if (this.parent != null) {
            return this.parent + "." + this.permissionTag;
        }
        return this.permissionTag;
    }

    public boolean hasPermission(HasPermission sender) {
        if (sender == null) {
            return true;
        }
        if (Permissions.hasPermissionManager) {
            return sender.hasPermission(this.toString());
        }
        switch (this.permissionDefault) {
            case TRUE: {
                return true;
            }
            case FALSE: {
                return false;
            }
            case OP: {
                return sender.isOp();
            }
            case NOT_OP: {
                return !sender.isOp();
            }
        }
        throw new IllegalStateException("Unexpected value: " + (Object)((Object)this.permissionDefault));
    }

    public List<PermissionBuilder> getChildren() {
        return ImmutableList.copyOf(this.children);
    }

    public List<PermissionBuilder> getGrantChildren() {
        return ImmutableList.copyOf(this.grantChildren);
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isDoNotExport() {
        return this.doNotExport;
    }

    public PermissionBuilder description(String description) {
        this.description = description;
        return this;
    }

    public static enum PermissionDefault {
        TRUE,
        FALSE,
        OP,
        NOT_OP;

    }
}

