/*
 * Decompiled with CFR 0.152.
 */
package com.sekwah.advancedportals.core.portal;

import com.sekwah.advancedportals.core.connector.containers.PlayerContainer;
import com.sekwah.advancedportals.core.portal.ActivationResult;
import com.sekwah.advancedportals.core.registry.TagRegistry;
import com.sekwah.advancedportals.core.registry.TagTarget;
import com.sekwah.advancedportals.core.repository.ConfigRepository;
import com.sekwah.advancedportals.core.serializeddata.BlockLocation;
import com.sekwah.advancedportals.core.serializeddata.DataTag;
import com.sekwah.advancedportals.core.serializeddata.PlayerData;
import com.sekwah.advancedportals.core.serializeddata.PlayerLocation;
import com.sekwah.advancedportals.core.services.PlayerDataServices;
import com.sekwah.advancedportals.core.util.Lang;
import com.sekwah.advancedportals.core.warphandler.ActivationData;
import com.sekwah.advancedportals.core.warphandler.Tag;
import com.sekwah.advancedportals.core.warphandler.TriggerType;
import com.sekwah.advancedportals.shadowed.inject.Inject;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;

public class AdvancedPortal
implements TagTarget {
    @Inject
    private transient TagRegistry tagRegistry;
    private BlockLocation maxLoc;
    private BlockLocation minLoc;
    private final HashMap<String, String[]> args = new HashMap();
    private transient List<DataTag> portalTags = new ArrayList<DataTag>();
    private transient boolean isSorted = false;
    @Inject
    private transient PlayerDataServices playerDataServices;
    @Inject
    transient ConfigRepository configRepository;

    public AdvancedPortal() {
        this.minLoc = new BlockLocation();
        this.maxLoc = new BlockLocation();
    }

    public AdvancedPortal(BlockLocation minLoc, BlockLocation maxLoc, TagRegistry tagRegistry, PlayerDataServices playerDataServices) {
        this.tagRegistry = tagRegistry;
        this.playerDataServices = playerDataServices;
        this.updateBounds(minLoc, maxLoc);
    }

    public BlockLocation getMaxLoc() {
        return this.maxLoc;
    }

    public BlockLocation getMinLoc() {
        return this.minLoc;
    }

    @Override
    public String[] getArgValues(String argName) {
        return this.args.get(argName);
    }

    @Override
    public void setArgValues(String argName, String[] argValues) {
        this.isSorted = false;
        this.args.put(argName, argValues);
    }

    @Override
    public void addArg(String argName, String argValues) {
    }

    public void updatePortalTagList() {
        this.portalTags.clear();
        boolean i = false;
        for (Map.Entry<String, String[]> entry : this.args.entrySet()) {
            this.portalTags.add(new DataTag(entry.getKey(), entry.getValue()));
        }
        this.portalTags.sort(Comparator.comparingInt(o -> {
            Tag tag = this.tagRegistry.getTag(o.NAME);
            if (tag instanceof Tag.OrderPriority) {
                Tag.OrderPriority tagPriority = (Tag.OrderPriority)((Object)tag);
                return tagPriority.getPriority().ordinal();
            }
            return Tag.Priority.NORMAL.ordinal();
        }));
        this.isSorted = true;
    }

    @Override
    public void removeArg(String arg) {
        this.isSorted = false;
        this.args.remove(arg);
    }

    public void updateBounds(BlockLocation loc1, BlockLocation loc2) {
        int minX = Math.min(loc1.getPosX(), loc2.getPosX());
        int minY = Math.min(loc1.getPosY(), loc2.getPosY());
        int minZ = Math.min(loc1.getPosZ(), loc2.getPosZ());
        int maxX = Math.max(loc1.getPosX(), loc2.getPosX());
        int maxY = Math.max(loc1.getPosY(), loc2.getPosY());
        int maxZ = Math.max(loc1.getPosZ(), loc2.getPosZ());
        this.minLoc = new BlockLocation(loc1.getWorldName(), minX, minY, minZ);
        this.maxLoc = new BlockLocation(loc2.getWorldName(), maxX, maxY, maxZ);
    }

    public ActivationResult activate(PlayerContainer player, TriggerType triggerType) {
        Tag.Activation activationHandler;
        PlayerData playerData;
        if (!this.isSorted) {
            this.updatePortalTagList();
        }
        if ((playerData = this.playerDataServices.getPlayerData(player)).hasJoinCooldown()) {
            int cooldown = (int)Math.ceil((double)playerData.getJoinCooldownLeft() / 1000.0);
            player.sendMessage(Lang.translateInsertVariables("portal.cooldown.join", cooldown, Lang.translate(cooldown == 1 ? "time.second" : "time.seconds")));
            if (this.configRepository.playFailSound()) {
                Random rand = new Random();
                player.playSound("block.portal.travel", 0.05f, rand.nextFloat() * 0.4f + 0.8f);
            }
            return ActivationResult.FAILED_DO_KNOCKBACK;
        }
        ActivationData data = new ActivationData(triggerType);
        for (DataTag portalTag : this.portalTags) {
            Tag.DenyBehavior denyBehaviorHandler;
            boolean preActivated;
            activationHandler = this.tagRegistry.getActivationHandler(portalTag.NAME, Tag.TagType.PORTAL);
            if (activationHandler == null || (preActivated = activationHandler.preActivated(this, player, data, this.getArgValues(portalTag.NAME)))) continue;
            if (activationHandler instanceof Tag.DenyBehavior && (denyBehaviorHandler = (Tag.DenyBehavior)((Object)activationHandler)).getDenyBehavior().equals((Object)Tag.DenyBehavior.Behaviour.SILENT)) {
                return ActivationResult.FAILED_DO_NOTHING;
            }
            return ActivationResult.FAILED_DO_KNOCKBACK;
        }
        for (DataTag portalTag : this.portalTags) {
            activationHandler = this.tagRegistry.getActivationHandler(portalTag.NAME, Tag.TagType.PORTAL);
            if (activationHandler == null || activationHandler.activated(this, player, data, this.getArgValues(portalTag.NAME))) continue;
            return ActivationResult.FAILED_DO_KNOCKBACK;
        }
        for (DataTag portalTag : this.portalTags) {
            activationHandler = this.tagRegistry.getActivationHandler(portalTag.NAME, Tag.TagType.PORTAL);
            if (activationHandler == null) continue;
            activationHandler.postActivated(this, player, data, this.getArgValues(portalTag.NAME));
        }
        if (data.hasActivated()) {
            playerData.setPortalBlockCooldown(1000L);
            playerData.setInPortal(this.getName());
            return ActivationResult.SUCCESS;
        }
        return ActivationResult.FAILED_DO_KNOCKBACK;
    }

    public boolean isLocationInPortal(BlockLocation loc) {
        return this.isLocationInPortal(loc, 0);
    }

    public boolean isLocationInPortal(PlayerLocation loc) {
        return this.isLocationInPortal(loc.toBlockPos(), 0);
    }

    public boolean isLocationInPortal(PlayerLocation loc, int additionalArea) {
        return this.isLocationInPortal(loc.toBlockPos(), additionalArea);
    }

    public boolean isLocationInPortal(BlockLocation loc, int additionalArea) {
        double playerX = loc.getPosX();
        double playerY = loc.getPosY();
        double playerZ = loc.getPosZ();
        return Objects.equals(loc.getWorldName(), this.minLoc.getWorldName()) && playerX >= (double)(this.minLoc.getPosX() - additionalArea) && playerX < (double)(this.maxLoc.getPosX() + 1 + additionalArea) && playerY >= (double)(this.minLoc.getPosY() - additionalArea) && playerY < (double)(this.maxLoc.getPosY() + 1 + additionalArea) && playerZ >= (double)(this.minLoc.getPosZ() - additionalArea) && playerZ < (double)(this.maxLoc.getPosZ() + 1 + additionalArea);
    }

    public void setArgValues(DataTag portalTag) {
        this.setArgValues(portalTag.NAME, portalTag.VALUES);
    }

    public ArrayList<DataTag> getArgs() {
        ArrayList<DataTag> tagList = new ArrayList<DataTag>();
        for (Map.Entry<String, String[]> entry : this.args.entrySet()) {
            tagList.add(new DataTag(entry.getKey(), entry.getValue()));
        }
        return tagList;
    }

    public boolean isTriggerBlock(String blockMaterial) {
        String[] triggerBlocks = this.getArgValues("triggerblock");
        if (triggerBlocks != null) {
            for (String triggerBlock : triggerBlocks) {
                if (!blockMaterial.equalsIgnoreCase(triggerBlock)) continue;
                return true;
            }
        }
        return false;
    }

    public String getName() {
        return this.getArgValues("name")[0];
    }
}

