/*
 * Decompiled with CFR 0.152.
 */
package com.sekwah.advancedportals.core.registry;

import com.sekwah.advancedportals.core.commands.SubCommand;
import com.sekwah.advancedportals.core.util.InfoLogger;
import com.sekwah.advancedportals.shadowed.inject.Inject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class SubCommandRegistry {
    protected Map<String, SubCommand> subCommandMap = new HashMap<String, SubCommand>();
    protected ArrayList<String> subCommands = new ArrayList();
    @Inject
    private InfoLogger infoLogger;

    public boolean registerSubCommand(String arg, SubCommand subCommand) {
        if (subCommand == null) {
            this.infoLogger.warning("The subcommand '" + arg + "' cannot be null.");
            return false;
        }
        if (this.subCommandMap.containsKey(arg)) {
            this.infoLogger.warning("The subcommand '" + arg + "' already exists.");
            return false;
        }
        this.subCommandMap.put(arg.toLowerCase(), subCommand);
        this.subCommands.add(arg.toLowerCase());
        Collections.sort(this.subCommands);
        return true;
    }

    public ArrayList<String> getSubCommands() {
        return this.subCommands;
    }

    public boolean isArgRegistered(String arg) {
        return this.subCommandMap.containsKey(arg.toLowerCase());
    }

    public SubCommand getSubCommand(String arg) {
        if (this.subCommandMap.containsKey(arg.toLowerCase())) {
            return this.subCommandMap.get(arg.toLowerCase());
        }
        return null;
    }
}

