/*
 * Decompiled with CFR 0.152.
 */
package com.sekwah.advancedportals.core.registry;

import com.sekwah.advancedportals.core.AdvancedPortalsCore;
import com.sekwah.advancedportals.core.warphandler.Tag;
import com.sekwah.advancedportals.shadowed.inject.Inject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TagRegistry {
    @Inject
    AdvancedPortalsCore portalsCore;
    private final ArrayList<String> literalTags = new ArrayList();
    private final ArrayList<Tag> tags = new ArrayList();
    private final Map<String, Tag> tagMap = new HashMap<String, Tag>();
    private final Map<String, Tag.Activation> activationTags = new HashMap<String, Tag.Activation>();
    private final Map<String, Tag.Creation> creationTags = new HashMap<String, Tag.Creation>();
    private final Map<String, Tag.TagStatus> statusTags = new HashMap<String, Tag.TagStatus>();
    @Inject
    private AdvancedPortalsCore pluginCore;

    public Tag.Activation getActivationHandler(String arg, Tag.TagType targetType) {
        Tag.Activation tag = this.activationTags.get(arg);
        if (tag != null && Arrays.asList(tag.getTagTypes()).contains((Object)targetType)) {
            return tag;
        }
        return null;
    }

    public Tag.Creation getCreationHandler(String arg) {
        return this.creationTags.get(arg);
    }

    public Tag.TagStatus getStatusHandler(String arg) {
        return this.statusTags.get(arg);
    }

    public boolean registerTag(Tag tag) {
        this.pluginCore.getModule().getInjector().injectMembers(tag);
        String tagName = tag.getName();
        this.tags.add(tag);
        if (this.literalTags.contains(tagName)) {
            this.portalsCore.getInfoLogger().warning("A tag with the name " + tagName + " already exists.");
            return false;
        }
        String[] aliases = tag.getAliases();
        this.literalTags.add(tagName);
        if (aliases != null) {
            for (String alias : aliases) {
                if (!this.literalTags.contains(alias)) continue;
                this.portalsCore.getInfoLogger().warning("A tag with the alias " + alias + " already exists.");
                return false;
            }
            Collections.addAll(this.literalTags, aliases);
        }
        if (tagName == null) {
            this.portalsCore.getInfoLogger().warning("A tag cannot be null.");
            return false;
        }
        this.tagMap.put(tagName, tag);
        if (tag instanceof Tag.Activation) {
            Tag.Activation tagActivation = (Tag.Activation)tag;
            this.activationTags.put(tagName, tagActivation);
        }
        if (tag instanceof Tag.TagStatus) {
            Tag.TagStatus tagStatus = (Tag.TagStatus)tag;
            this.statusTags.put(tagName, tagStatus);
        }
        if (tag instanceof Tag.Creation) {
            Tag.Creation tagCreation = (Tag.Creation)tag;
            this.creationTags.put(tagName, tagCreation);
        }
        return true;
    }

    public Tag getTag(String tagName) {
        return this.tagMap.get(tagName);
    }

    public List<Tag> getTags() {
        return new ArrayList<Tag>(this.tags);
    }
}

