/*
 * Decompiled with CFR 0.152.
 */
package com.sekwah.advancedportals.core.registry;

import com.sekwah.advancedportals.core.AdvancedPortalsCore;
import com.sekwah.advancedportals.core.effect.WarpEffect;
import com.sekwah.advancedportals.core.util.InfoLogger;
import com.sekwah.advancedportals.shadowed.inject.Inject;
import java.util.HashMap;
import java.util.Map;

public class WarpEffectRegistry {
    private Map<String, WarpEffect> warpEffects = new HashMap<String, WarpEffect>();
    @Inject
    private AdvancedPortalsCore portalsCore;
    @Inject
    private InfoLogger infoLogger;

    public void registerEffect(String name, WarpEffect effect) {
        if (name == null) {
            this.infoLogger.warning("Effect name cannot be null");
            return;
        }
        if (this.warpEffects.containsKey(name)) {
            this.infoLogger.warning("Effect with the name: " + name + " already exists");
            return;
        }
        this.warpEffects.put(name, effect);
    }

    public WarpEffect.Visual getVisualEffect(String name) {
        if (this.warpEffects.containsKey(name.toLowerCase())) {
            WarpEffect effect = this.warpEffects.get(name);
            if (effect instanceof WarpEffect.Visual) {
                WarpEffect.Visual visual = (WarpEffect.Visual)effect;
                return visual;
            }
            this.infoLogger.warning("Effect called " + name + " is not a visual effect");
            return null;
        }
        this.infoLogger.warning("No effect called " + name + " is registered");
        return null;
    }

    public WarpEffect.Sound getSoundEffect(String name) {
        if (this.warpEffects.containsKey(name)) {
            WarpEffect effect = this.warpEffects.get(name);
            if (effect instanceof WarpEffect.Sound) {
                return (WarpEffect.Sound)effect;
            }
            this.infoLogger.warning("Effect called " + name + " is not a sound effect");
            return null;
        }
        this.infoLogger.warning("No effect called " + name + " is registered");
        return null;
    }
}

