/*
 * Decompiled with CFR 0.152.
 */
package com.sekwah.advancedportals.core.repository.impl;

import com.sekwah.advancedportals.core.destination.Destination;
import com.sekwah.advancedportals.core.repository.IDestinationRepository;
import com.sekwah.advancedportals.core.serializeddata.DataStorage;
import com.sekwah.advancedportals.core.tags.NameTag;
import com.sekwah.advancedportals.shadowed.inject.Inject;
import com.sekwah.advancedportals.shadowed.inject.Singleton;
import java.util.ArrayList;
import java.util.List;

@Singleton
public class DestinationRepositoryImpl
implements IDestinationRepository {
    private final String fileLocation = "desti/";
    @Inject
    DataStorage dataStorage;

    private boolean isValidName(String name) {
        return name != null && !name.contains("/") && !name.contains("\\");
    }

    @Override
    public boolean save(String name, Destination destination) {
        if (!this.isValidName(name)) {
            throw new IllegalArgumentException("Invalid name: " + name);
        }
        return this.dataStorage.storeFile(destination, "desti/" + name + ".yaml");
    }

    @Override
    public boolean containsKey(String name) {
        if (!this.isValidName(name)) {
            throw new IllegalArgumentException("Invalid name: " + name);
        }
        return this.dataStorage.fileExists("desti/" + name + ".yaml");
    }

    @Override
    public boolean delete(String name) {
        if (!this.isValidName(name)) {
            throw new IllegalArgumentException("Invalid name: " + name);
        }
        return this.dataStorage.deleteFile("desti/" + name + ".yaml");
    }

    @Override
    public Destination get(String name) {
        if (!this.isValidName(name)) {
            throw new IllegalArgumentException("Invalid name: " + name);
        }
        return this.dataStorage.loadFile(Destination.class, "desti/" + name + ".yaml");
    }

    @Override
    public List<String> getAllNames() {
        return this.dataStorage.listAllFiles("desti/", true);
    }

    @Override
    public List<Destination> getAll() {
        ArrayList<Destination> destinations = new ArrayList<Destination>();
        List<String> allFiles = this.dataStorage.listAllFiles("desti/", true);
        for (String fileName : allFiles) {
            Destination destination = this.get(fileName);
            String[] name = destination.getArgValues(NameTag.TAG_NAME);
            if (name != null && name.length > 0) {
                destination.setArgValues(NameTag.TAG_NAME, new String[]{fileName});
            }
            destinations.add(destination);
        }
        return destinations;
    }
}

