/*
 * Decompiled with CFR 0.152.
 */
package com.sekwah.advancedportals.core.repository.impl;

import com.sekwah.advancedportals.core.AdvancedPortalsCore;
import com.sekwah.advancedportals.core.portal.AdvancedPortal;
import com.sekwah.advancedportals.core.repository.IPortalRepository;
import com.sekwah.advancedportals.core.serializeddata.DataStorage;
import com.sekwah.advancedportals.core.tags.NameTag;
import com.sekwah.advancedportals.shadowed.inject.Inject;
import com.sekwah.advancedportals.shadowed.inject.Singleton;
import java.util.ArrayList;
import java.util.List;

@Singleton
public class PortalRepositoryImpl
implements IPortalRepository {
    private final String fileLocation = "portals/";
    @Inject
    DataStorage dataStorage;
    private List<AdvancedPortal> portals = new ArrayList<AdvancedPortal>();

    private boolean isValidName(String name) {
        return name != null && !name.contains("/") && !name.contains("\\");
    }

    @Override
    public boolean save(String name, AdvancedPortal portal) {
        if (!this.isValidName(name)) {
            throw new IllegalArgumentException("Invalid name: " + name);
        }
        return this.dataStorage.storeFile(portal, "portals/" + name + ".yaml");
    }

    @Override
    public boolean containsKey(String name) {
        if (!this.isValidName(name)) {
            throw new IllegalArgumentException("Invalid name: " + name);
        }
        return this.dataStorage.fileExists("portals/" + name + ".yaml");
    }

    @Override
    public boolean delete(String name) {
        if (!this.isValidName(name)) {
            throw new IllegalArgumentException("Invalid name: " + name);
        }
        return this.dataStorage.deleteFile("portals/" + name + ".yaml");
    }

    @Override
    public AdvancedPortal get(String name) {
        if (!this.isValidName(name)) {
            throw new IllegalArgumentException("Invalid name: " + name);
        }
        AdvancedPortal portal = this.dataStorage.loadFile(AdvancedPortal.class, "portals/" + name + ".yaml");
        if (portal != null) {
            AdvancedPortalsCore.getInstance().getModule().getInjector().injectMembers(portal);
        }
        return portal;
    }

    @Override
    public List<String> getAllNames() {
        return this.dataStorage.listAllFiles("portals/", true, "yaml");
    }

    @Override
    public List<AdvancedPortal> getAll() {
        ArrayList<AdvancedPortal> portals = new ArrayList<AdvancedPortal>();
        List<String> allFiles = this.dataStorage.listAllFiles("portals/", false);
        for (String fileName : allFiles) {
            String[] name;
            AdvancedPortal portal = this.dataStorage.loadFile(AdvancedPortal.class, "portals/" + fileName);
            if (portal != null) {
                AdvancedPortalsCore.getInstance().getModule().getInjector().injectMembers(portal);
            }
            if ((name = portal.getArgValues(NameTag.TAG_NAME)) != null && name.length > 0) {
                portal.setArgValues(NameTag.TAG_NAME, new String[]{fileName.replace(".yaml", "")});
            }
            portals.add(portal);
        }
        return portals;
    }
}

